import axios from 'axios'  //引入axios
//创建axios对象
const instance = axios.create({
  baseURL: '/api',
  timeout: 20000,
});
// http request 拦截器
instance.interceptors.request.use(
  config => {
    // if (store.state.token) { // 判断是否存在token，如果存在的话，则每个http header都加上token
    //   config.headers.authorization = store.state.token  //请求头加上token
    // }
    return config
  },
  err => {
    return Promise.reject(err)
})
// http response 拦截器
instance.interceptors.response.use(
  response => {
    //拦截响应，做统一处理
    return response
  },
  //接口错误状态处理，也就是说无响应时的处理
  error => {
    return Promise.reject(error.response.data) // 返回接口返回的错误信息
})
export default instance
