import Vue from 'vue'
import Router from 'vue-router'
import Order from './routers/order.js'
import Goods from './routers/goods.js'
import Marketing from './routers/marketing.js'
import Checking from './routers/checking.js'
import Help from './routers/help.js'
import others from './routers/others.js'

Vue.use(Router)
const _import = (data) => resolve => require(['@/' + data + '.vue'], resolve);

export default new Router({
  mode: 'history',  //去掉url中的#
  routes: [
    {
      path: '/',
      redirect: '/home'
    },
    {
      path: '/home',
      component:_import('components/Home'),
      meta:{},
      children:[
         {
            path: '/',
            name: 'index',
            component:_import('pages/Index'),
            meta: {
              title: '首页',
              breadcrumb: [],
              hideSidebar:true,
              isBackTran:true
            }
          },
          {
            path: '/404',
            component:_import('pages/404'),
            meta: { title: '404', hideSidebar:true },

          },
        {
          path: '/salesRankingService',
          component:_import('pages/marketing/statistics/salesRankingService'),
          meta: { title: '开通品牌销售排行服务', hideSidebar:true },

        },
        {
          path: '/marketing/AddActivityProduct',
          component:_import('pages/marketing/activity/model/AddActivityProduct'),
          meta: {
            isShow:true,
            title: '活动管理',
            breadcrumb: ['活动管理','活动报名' ],
          }
        },
        {
          path: '/marketing/AddActivityProduct-act',
          component:_import('pages/marketing/activityCopy/model/AddActivityProduct'),
          meta: {
            isShow:true,
            title: '活动管理',
            breadcrumb: ['活动管理','活动报名' ],
            actName:'/marketing/brandActivity'
          }
        },
        {
          path: '/marketing/salesOverview',
          component:_import('pages/marketing/sales/salesOverview'),
          meta: {
            isShow:true,
            title: '数据分析',
            breadcrumb: ['数据分析','售后总览' ],
          }
        },
        ...Order,
        ...Goods,
        //营销推广
        ...Marketing,
        //财务对账
        ...Checking,
        //帮助中心
        ...Help,

        //通知
        {
          path: '/notice/list',
          component:_import('pages/notice/List'),

          meta: {
            title: '通知列表',
            breadcrumb: ['通知列表',],
            hideSidebar:true
          }
        },{
          path: '/notice/details',
          component:_import('pages/notice/details'),
          meta: {
            title: '通知详情',
            breadcrumb: [{name:'返回首页',path:'/'},'通知详情'],
            hideSidebar:true
          }
        },
        // 设置密码
        {
          path: '/set/setpwd',
          component:_import('pages/set/setpwd'),
          meta: {
            title: '密码管理',
            breadcrumb: [{name:'返回首页',path:'/'},'密码管理'],
            hideSidebar:true
          }
        },
         // vip充值
         {
          path: '/vippay',
          name:'/vippay',
          component:_import('pages/vippay'),
          meta: {
            title: '权益升级',
            breadcrumb: [{name:'返回首页',path:'/'},'权益升级'],
            hideSidebar:true
          }
        },

      ]
    },
    {
      path: '/login',
      component:_import('pages/Login'),

      meta:{
        unRequiresAuth: true
      }
    },
    {
      path: '/m_login',
      component:_import('pages/m_Login'),

      meta:{
        unRequiresAuth: true
      }
    },
    ...others,

    {
      path: '*',
      redirect: '/404'
    }
  ],
  scrollBehavior(to, from, savedPosition) {
    if (savedPosition) {
      return savedPosition
    } else {
      return { x: 0, y: 0 }
    }
  }
})
// 解决ElementUI导航栏中的vue-router在3.0版本以上重复点菜单报错问题
const originalPush = Router.prototype.push
Router.prototype.push = function push (location) {
  return originalPush.call(this, location).catch(err => err)
}
