const _import = (data) => resolve => require(['@/' + data + '.vue'], resolve);

export default [
      {
        path: '/marketing/shoprenovation',
        component:_import('pages/marketing/shop/shopRenovation'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广', '店铺管理', '店铺装修'],
          noToTop:true,
        }
      },
      {
        path: '/marketing/preview',
        component:_import('pages/marketing/shop/preview'),

        meta: {
          title: '营销推广',
          breadcrumb: [{name:'返回店铺管理',path:'/marketing/shoprenovation'},'店铺预览'],
          hideSidebar:true,
        }
      },
      {
        path: '/marketing/brandintroduce',
        component:_import('pages/marketing/shop/brand/introduce'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广', '店铺管理', '品牌介绍'],
        }
      },
      {
        path: '/marketing/planadd',
        component:_import('pages/marketing/shop/brand/planAdd'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广', '店铺管理', '编辑方案'],
        }
      },
      //营销推广----广告管理
      {
        path: '/marketing/advert',
        component:_import('pages/marketing/advert/adList'),
        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广', '广告服务', '广告管理'],
        }
      },
      {
        path: '/marketing/adedit',
        component:_import('pages/marketing/advert/adEdit'),
        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广', '广告管理', '我的广告', '广告编辑'],
        }
      },
      {
        path: '/marketing/admalledit',
        component:_import('pages/marketing/advert/adMallEdit'),
        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广', '广告管理', '广告商城', '广告编辑'],
        }
      },
       //营销推广----推广工具
      {
        path: '/marketing/coupon',
        component:_import('pages/marketing/tools/coupon'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','推广工具','优惠券' ],
        }
      },{
        path: '/marketing/pay',

        component:_import('pages/marketing/tools/pay'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','推广工具','EDS扫码付'],
        }
      },
      {
        path: '/goods/productdetails',
        component:_import('pages/goods/ProductDetails'),

        meta: {
          title: '商品详情',
          breadcrumb: [{name:'返回上一级',goback:"back"},'商品','商品详情'],
        }
      },
          //营销推广----推广工具---优惠券
          {
            path: '/marketing/addcoupon',
            component:_import('pages/marketing/tools/addcoupon'),

            meta: {
              title: '营销推广',
              breadcrumb: ['营销推广','推广工具','新增优惠券' ],
            }
          },
          {
            path: '/marketing/coupondetails',
        component:_import('pages/marketing/tools/couponDetails'),

            meta: {
              title: '营销推广',
              breadcrumb: ['营销推广','推广工具','优惠券详情' ],
            }
          },
      {
        path: '/marketing/msn',
        component:_import('pages/marketing/tools/msn'),
        meta: {
          title: '订阅号服务',
          breadcrumb: ['营销推广','信息管理','订阅号服务'],
        }
      },
      //营销推广----信息管理
      {
        path: '/marketing/holiday',
        component:_import('pages/marketing/info/holiday'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','信息管理','放假通知' ],
        }
      },
      {
        path: '/marketing/stock',
        component:_import('pages/marketing/info/stock'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','信息管理','库存预警' ],
        }
      },
      {
        path: '/marketing/service',
        component:_import('pages/marketing/info/service'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','信息管理','店铺客服' ],
        }
      },
      {
        path: '/marketing/message',
        component:_import('pages/marketing/info/message'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','信息管理','消息通知' ],
        }
      },
      //营销推广----工具下载
      {
        path: '/marketing/soft',
        component:_import('pages/marketing/download/soft'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','工具下载' ],
        }
      },
      {
        path: '/marketing/salerank',
        component:_import('pages/marketing/statistics/saleRank'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','销售排行' ],
        }
      },
      {
        path: '/marketing/report',
        component:_import('pages/marketing/statistics/report'),

        meta: {
          title: '营销推广',
          breadcrumb: ['营销推广','运营数据报告' ],
        }
      },
      {
        path: '/marketing/printreport',
        component:_import('pages/marketing/statistics/printReport'),
        meta: {
          title: '营销推广',
          breadcrumb: [],
          noToTop:true,
          hideSidebar:true,
          isBackTran:true
        }
      },
      {
         path: '/marketing/salerankad',
         component:_import('pages/marketing/statistics/saleRankAd'),
         meta: {
           title: '营销推广',
           breadcrumb: [],
           noToTop:true,
           hideSidebar:true,
           isBackTran:true
         }
       },
  {
    path: '/marketing/activityMall',
    component:_import('pages/marketing/activity/activityMall'),
    meta: {
      isShow:true,
      title: '活动管理',
      breadcrumb: ['活动管理','活动报名' ],
    }
  },
  {
    path: '/marketing/activityMall-act',
    component:_import('pages/marketing/activityCopy/activityMall'),
    meta: {
      isShow:true,
      title: '活动管理',
      breadcrumb: ['活动管理','活动报名' ],
      actName:'/marketing/brandActivity'
    }
  },
  {
    path: '/marketing/brandActivity',
    component:_import('pages/marketing/brandActivity/index'),
    meta: {
      isShow:true,
      title: '活动管理',
      breadcrumb: ['活动管理','品牌活动' ],
    }
  },
  {
    path: '/marketing/salesOverview',
    component:_import('pages/marketing/sales/salesOverview'),
    meta: {
      title: '数据分析',
      breadcrumb: ['数据分析','售后总览' ],
    }
  },
]
