/**
 * 文件验证
 * params: result -> 验证成功与否 code -> 图片是否加载成功
 */
class FileVerification {
  file = null;
  constructor(file) {
    this.file = file;
  }
  /**
   * 验证文件大小
   * 参数:   number （单位：KB）
   * 返回值: boolean
   */
  vSize(size) {
    let result = this.file.size / 1024 < size
    return {result:result,msg:'请上传' + size + 'K以内的文件'}
  }
  /**
   * 验证图片的宽高比大小
   * 参数:  w:宽  (number)
   *        h:高  (number)
   *        tolerant: 容错 （默认0.1，可不传）(number)
   * 返回值: Promise
   */
  vImgPercentage(w, h, tolerant = 0.1) {
    var self = this;
    return new Promise((resolve, reject) => {
      if (!this.vIsImage()) {
        resolve(this._returnErr())
      } else {
        self.vOnload().then((img) => {
          var percentage = (img.width / img.height);
          var width = img.width;
          var height = img.height;
          var result = Math.abs((w / h) - (width / height)) < tolerant;
          resolve({
            result,
            w,
            h,
            imgW: width,
            imgH: height,
            tolerant,
            percentage,
            code: 1,
            msg: result?null:"请上传正确比例的图片"
          })
        }).catch(err=>{
          resolve(this._returnErr(err))
        })
      }

    })
  }
  /**
   * 验证图片宽度
   * 参数:   w (number)
   * 返回值: Promise
   */
  vImgW(w) {
    return this.vImgWH(w);
  }
  /**
  * 验证图片宽度
  * 参数:   w (number)
  * 返回值: Promise
  */
  vImgH(h) {
    return this.vImgWH(null, h);
  }
  /**
   * 验证图片宽高
   * 参数: w (number)
   *        h (number)
   * 返回值：Promise
   */
  vImgWH(w, h) {
    var self = this;
    return new Promise((resolve, reject) => {
      if (!this.vIsImage()) {
        resolve(this._returnErr())
      } else {
        self.vOnload().then((img) => {
          var result;
          var width = img.width;
          var height = img.height;
          var message = ""

          if(w && h){
            message = "请上传" + w + "*" + h + "像素的图片格式文件"
          }else if(w && !h){
            message = "请上传宽度为" + w + "像素的图片"
          }else if(!w && h){
            message = "请上传高度为" + h + "像素的图片"
          }else{
            message = "请按要求上传图片"
          }

          if (w && h) {
            result = (w == width && h == height);
          } else if (w) {
            result = (w == img.width);
          } else {
            result = (h == img.height)
          }
          resolve({
            result: result,
            w,
            h,
            imgW: width,
            imgH: height,
            code: 1,
            msg: result?null:message
          })
        }).catch(err=>{
          resolve(this._returnErr(err))
        })
      }
    })
  }
  /**
   * 验证是否为图片文件
   * 返回值: boolean
   */
  vIsImage() {
    var result = this.file.type.indexOf("image/") != -1
    return {result}
  }
  /**
   * 验证是否为视频文件
   * 返回值: boolean
   */
  vIsVideo() {
    var result = this.file.type.indexOf("video/") != -1
    return {result}
  }

  /**
   * 验证文件扩展名
   * 参数: ext (array<string> || string)
   * 返回值: number (-1不存在，反之存在)
   */
  vExt(ext) {
    var arrExt = Object.prototype.toString.call(ext) === "[object Array]" ? ext : [ext];
    var fileExt = /\.[^\.]+$/.exec(this.file.name)[0].replace(".", "");
    var result = arrExt.indexOf(fileExt) > -1
    return {result};
  }
  vOnload() {
    var _URL = window.URL || window.webkitURL;
    var img;
    img = new Image();
    img.src = _URL.createObjectURL(this.file);
    return new Promise((resolve, reject) => {
      img.onload = () => {
        resolve(img)
      }
      img.onerror= () => {
        reject("图片加载失败")
      }
    })
  }
  _returnErr(msg) {
    return {
      result: false,
      msg: msg || "请按要求上传文件",
      code: 0
    }
  }
}

export default FileVerification;
