/**
 *  pages 页面快速生成脚本
 *
 *  npm run tem '文件名‘
*/

const fs = require('fs')
const dirName = process.argv[2]
const capPirName = dirName.substring(0, 1).toUpperCase() + dirName.substring(1);

if (!dirName) {
  console.log('文件名不能为空');
  console.log('用法：npm run tem test');
  process.exit(0);
}

// 页面模板构建

const indexTep = `
<template>
  <div class="p_all_20">
    ${dirName}
    <span class="iconfont iconsousuo"></span>
    <Hello />
  </div>
</template>

<script>
// 导入组件
import Hello from '../components/Hello'

export default {
  name: '${dirName}',
  data () {
    return {

    }
  },
  props:{
    //接收参数
  },
  mounted() {
    // 时间钩子
  },
  methods:{
    // 执行方法
  },
  components:{
    // 传入组件
    Hello
  }
}
</script>

<style lang="scss" scoped>

</style>
`

// fs.mkdirSync(`./src/pages/${dirName}`); // mkdir $1
process.chdir(`./src/pages`); // cd $1

fs.writeFileSync(`${dirName}.vue`, indexTep); //vue

process.exit(0);
