const _import = (data) => resolve => require(['@/' + data + '.vue'], resolve);

export default [
    {
        path: '/goods/goodslist',
        component:_import('pages/goods/goodslist'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '列表'],
        }
      },
      {
        path: '/goods/list',
        component:_import('pages/goods/list'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '商品列表'],
          keepAlive:true,
          isBack:false
        }
      },
      {
        path: '/goods/details',
        component:_import('pages/goods/details'),

        meta: {
          title: '商品管理',
          breadcrumb: [{name:'返回上一级',goback:"back"},'商品管理', '商品列表', '商品详情'],

        }
      },
      {
        path: '/goods/template',
        component:_import('pages/goods/template'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '商品列表', '新建商品'],

        }
      },
      {
        path: '/goods/newProduct',
        component:_import('pages/goods/newProduct'),

        meta: {
          title: '商品管理',
          breadcrumb: [{name:'返回上一级',goback:"back"},'商品管理','商品列表', '编辑商品详情'],

        }
      },
      // 旧数据迁移仓库
      {
        path: '/goods/listold',
        component:_import('pages/goods/listold'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '旧数据迁移仓库列表'],

        }
      },
      {
        path: '/goods/templateold',
        component:_import('pages/goods/templateold'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '旧数据迁移仓库列表', '新建商品'],

        }
      },
      {
        path: '/goods/newProductold',
        component:_import('pages/goods/newProductOldData'),
        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '旧数据迁移仓库', '编辑商品详情'],

        }
      },
      {
        path: '/goods/detailsold',
        component:_import('pages/goods/detailsold'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '商品列表', '商品详情'],

        }
      },
      {
        path: '/goods/warnstock',
        component:_import('pages/goods/warnStock'),

        meta: {
          title: '商品管理',
          breadcrumb: ['商品管理', '库存管理'],
          keepAlive:true,
          isBack:false
        }
      },
      // {
      //   path: '/goods/limit',
      //   component:_import('pages/goods/limitlist'),
      //
      //   meta: {
      //     title: '商品管理',
      //     breadcrumb: ['专区管理', '限量专区'],
      //     keepAlive:true,
      //     isBack:false
      //   }
      // },
  {
    path: '/goods/seckill',
    component:_import('pages/goods/seckill'),

    meta: {
      title: '商品管理',
      breadcrumb: ['专区管理', '秒杀专区'],
      keepAlive:true,
      isBack:false
    }
  },
  {
    path: '/goods/xinPin',
    component:_import('pages/goods/xinPin'),

    meta: {
      title: '商品管理',
      breadcrumb: ['专区管理', '新品专区'],
      keepAlive:true,
      isBack:false
    }
  },
]
