const _import = (data) => resolve => require(['@/' + data + '.vue'], resolve);
export default [{
    path: '/order/orderlist/:type?',
    name:'/order/orderlist',
    component:_import('pages/order/orderlist'),
    meta: {
      title: '订单',
      breadcrumb: ['订单', '订单列表'],
      keepAlive:true,
      isBack:false
    }
  },{
    path: '/order/frmOrderDetail',
    name:'/order/frmOrderDetail',
    component:_import('pages/order/frmOrderDetail'),
    meta: {
      title: '订单',
      breadcrumb: [{name:'返回上一级',goback:"back"},'订单','订单列表','订单详情'],
    }
  },{
    path: '/order/refundProcessing',
    name:'/order/refundProcessing',
    component:_import('pages/order/refundProcessing'),
    meta: {
      title: '订单',
      breadcrumb: [{name:'返回上一级',goback:"back"},'订单', '退款订单处理'],
    }
  },
  //自营订单管理
  {
    path: '/order/orderlistself/',
    name:'/order/orderlistself',
    component:_import('pages/order/orderlistself'),
    meta: {
      title: '订单',
      breadcrumb: ['订单', '订单列表'],
      keepAlive:true,
      isBack:false //回退保持原来的位置
    }
  },
   // 扫码订单
   {
    path: '/order/saomafu',
    name:'/order/saomafu',
    component:_import('pages/order/SaoMaFu'),
    meta: {
      title: '订单',
      breadcrumb: ['订单', '订单列表'],
      keepAlive:true,
      isBack:false
    }
  },
  {
    path: '/order/frdsaomafu',
    name:'/order/frdsaomafu',
    component:_import('pages/order/frmOrderDetailSaomafu'),

    meta: {
      title: '订单',
      breadcrumb: [{name:'返回上一级',goback:"back"},'订单','扫码付订单', '扫码付订单详情'],
    }
  },
  //E淘品牌共享中心
  {
    path: '/order/frmOrderDetailBrand',
    name:'/order/frmOrderDetailBrand',
    component:_import('pages/order/frmOrderDetailBrand'),

    meta: {
      title: '订单',
      breadcrumb: [{name:'返回上一级',goback:"back"},'订单','订单列表','共享中心订单详情'],
    }
  },
  {
    path: '/order/orderlistbrand/:type?',
    name:'/order/orderlistbrand',
    component:_import('pages/order/orderlistbrand'),

    meta: {
      title: '订单',
      breadcrumb: ['订单', '订单列表'],
      keepAlive:true,
      isBack:false
    }
  },
  //A店合同
  {
    path: '/order/orderlistashop',
    name:'/order/orderlistashop',
    component:_import('pages/order/orderlistAshop'),

    meta: {
      title: '订单',
      breadcrumb: ['订单', '订单列表'],
      keepAlive:true,
      isBack:false
    }
  },{
    path: '/order/frdashop',
    name:'/order/frdashop',
    component:_import('pages/order/frmOrderDetailAshop'),

    meta: {
      title: '订单',
      breadcrumb: [{name:'返回上一级',goback:"back"},'订单','订单列表','A店合同详情'],
    }
  },
  {
    path: '/printorder',
    component:_import('pages/order/component/PrintOrder'),
    meta: {
      title: '打印订单',
      breadcrumb: ['订单', '打印订单'],
    }
  },
  // 售后
  {
    path: '/aftersale/index',
    component:_import('pages/afterSale/index'),
    meta: {
      title: '订单',
      breadcrumb: ['订单','售后/投诉'],
    }
  },
  {
    path: '/aftersale/details',
    component: _import('pages/afterSale/details'),
    meta: {
      title: '订单',
      breadcrumb: ['订单','售后/投诉'],
    }
  },
  //售后2.0
  {
    path: '/aftersale/indexsale',
    component:_import('pages/afterSale/indexSale'),
    meta: {
      title: '订单',
      breadcrumb: ['订单','售后'],
    }
  },
  {
    path: '/aftersale/detailsale',
    component: _import('pages/afterSale/detailSale'),
    meta: {
      title: '订单',
      breadcrumb: ['订单','售后详情'],
    }
  },
]