import router from '../../router'
import $axios from 'axios'
// mapGetters，mapState 放computed
// mapMutations 放 methods
export default {
  // data
  name:'导航栏',
  namespaced: true,//模板独立命名
  state: {
    collapse: false,//左侧侧边折叠
    actNavItem: 0,
    orderTip:{}, //超过三天未处理订单
    newOrderTip:{}//新订单提醒
  },
  // computed
  getters:{
    
  },
  // methods
  // this.$store.commit(mutataionName) 调用
  mutations: {
    // 同 步
    //侧边栏折叠
    collapseChage (state) {
        state.collapse = !state.collapse

        sessionStorage.setItem('state', JSON.stringify(state))
    },
     clickNavItem(state,payload) {
    //   console.log('payload---',payload)
     
      state.actNavItem = payload.index != undefined?payload.index:payload
      if(payload.url){
        //在跳转外链接的时，默认返回到首页
        state.actNavItem =0;
        router.push({path:'/home'})
        window.open(payload.url,'_blank')
        return false; 
      }
      if(payload.route){
        // 头部菜单跳转
        router.push({path:payload.route})
      }
      sessionStorage.setItem('state', JSON.stringify(state))
    },
    getOrderTimeOutTip(state){
      $axios.get("/order/timeOutTip").then(res=>{
         let { code,data} = res.data;
         if(code ==200){
           state.orderTip =data;
         }
    })
   },
   getNewOrder(state) {
    $axios.get("/order/lookFlag").then(res => {
      let { code, data } = res.data;
      if (code == 200) {
        state.newOrderTip=data;
      }
    });
  }
  }
}
