// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import router from './router'
import Element from 'element-ui';
import axios from 'axios'
// import 'element-ui/lib/theme-chalk/index.css';
// import '@/assets/theme/index.css'; //自定义主题色
import '@/assets/theme/element-variables.scss' //自定义主题色
import './assets/styles/rest.css' // 初始化样式
import 'default-passive-events'
import store from '@/store'
import { _getStorage,_saveStorage } from '@/utils/utils'
import '@/utils/autoScreen'
Vue.use(Element,{size:'small'});
Vue.config.productionTip = false //是否启动生产消息
Vue.prototype.$bus = new Vue()
Vue.prototype.$axios = axios;

axios.defaults.baseURL = '/api'
Vue.prototype.sjEdsmallUrl = window.location.href.indexOf('-pre') != -1?'https://sj-pre.edsmall.com/TaoTaoTao/Index.aspx':'https://sj.edsmall.com/TaoTaoTao/Index.aspx'
Vue.prototype.ImgServerUrl = 'https://img.edsmall.com/ROOT/ETao/gl/'
var clientWidthSize = document.documentElement.clientWidth;
// if(clientWidthSize <= 1366){
  Vue.prototype.widthSize = {
    productWidth:230,//商品
    numberWidth:120, //数字框，数量/单价/结算金额/实付款
    numberWidth2:80,
    numberWidth3:150,
    receiverWidth:120, //收货人
    dealWidth:'',//交易状态
    guideWidth:120, //导购
    purchaseWidth:120,//采购单
    collectWidth:120, //收银小票
    rebateWidth:120,//市代返利
    eraWidth:120,//市代
    deductionWidth:160, //抵扣
  }
// }else{
//   Vue.prototype.widthSize = {
//     productWidth:350,
//     numberWidth:180,
//     receiverWidth:180,
//     dealWidth:'',
//     guideWidth:120,
//     purchaseWidth:320,
//     collectWidth:200,
//     rebateWidth:120,
//     eraWidth:150,
//     deductionWidth:200, //抵扣
//   }
// }

//判断是否移动端
var pathLogin = '/login';


// 头部加入token
var info =_getStorage('info')?_getStorage('info'):"";
var token=info&&info.token?info.token:'';
if(token==""){
  router.replace({
    path:pathLogin
  })
}
axios.defaults.headers.common['Authorization'] = token;
axios.interceptors.response.use(response => {

	return response;
},error =>{
  if(error.response.status == 401){
      // 清除token
      localStorage.removeItem('info');
      
      setTimeout(() => {
        router.replace({
          path:pathLogin
        })
      },1000)
  }
  return error
  
});


router.beforeEach((to, from, next) => {
  if (to.matched.some(record => record.meta.unRequiresAuth)) {
    next()
  } else {
    var info = _getStorage('info');
    if (info && info.token) {
      next();
    } else {
      next({
        path: pathLogin
      })
    }
  }

})

/* eslint-disable no-new */
new Vue({
  el: '#app',
  store,
  router,
  components: { App },
  template: '<App/>'
})
