const app=getApp();
Page({
  data: {
    headImg:'',
    storeName:'',
    showPrivacy: false,
    defurl:app.globalData.defurl,
    userInfo:'',
    paramsUrl:'',
    openId:'',
  },
  onLoad: function (options) {
    this.getInfo()
    try{
      wx.getPrivacySetting({
        success: res => {
          if (res.needAuthorization) {
            // 需要弹出隐私协议
            this.setData({
              showPrivacy: true
            })
          }
        },
        fail: () => {
        },
        complete: () => {
        }
      })
    }catch (e) {
      this.setData({
        showPrivacy: false
      })
    }

    var name = options.name || app.globalData.userInfo;
    var paramsUrl=  options.url || '';
    this.setData({
      name: name,
      paramsUrl: paramsUrl
    })
    this.getOpenId();

  },
  getInfo(){
    let that = this
    let subdomain=''
    let appId = wx.getAccountInfoSync().miniProgram.appId
    if(appId=='wxdb3d8f9a94eca8d9'){
      subdomain='jinyanxia'
    }else if(appId=='wx175347bd3977d6a9'){
      subdomain='21'
    }else if(appId=='wx7dca103eaf35d1f7'){
      subdomain='wuyoushop0571jg0001'
    }else if(appId=='wxca8cfe95f6fa0e0b'){
      subdomain='guoxindengshi'
    }else if(appId=='wxbe067c202501e58a'){
      subdomain='xmy888'
    }
    wx.request({
      url: app.globalData.defurl + '/api/store/info?link='+subdomain,
      success: function (res) {
        that.setData({
          headImg:res.data.data.headImg,
          storeName:res.data.data.storeName,
        })
      },
      complete(){
        wx.hideLoading();
      }
    })
  },
  getOpenId(){
    wx.showLoading({
      title: '加载中...',
      mask: true
    })
    var that=this;
    wx.login({
      success(res){
        var code=res.code;
        wx.request({
          url: app.globalData.defurl + '/WeiXin/GetOpenId',
          data: {
            Code: code,
          },
          success: function (res) {
            if(res.data.code==1){
              that.setData({
                openId:res.data.data
              })
            }
          },
          complete(){
            wx.hideLoading();
          }
        })
      },fail(){
        
      }
    })
  },  
  onReady: function () {
  
  },
  onShow: function () {
  
  },

  onHide: function () {
  
  },

  onUnload: function () {
  
  },

  onPullDownRefresh: function () {
  
  },

  onReachBottom: function () {
  
  },
  getPhoneNumber: function (e) {
    const that = this;
    if (!e.detail.iv && !e.detail.encryptedData){
        return false;
    }
    if (!that.data.openId){
      this.wxFastLoginFail();
      return false;
    }
    wx.showLoading({
      title: '登陆中...',
      mask:true
    })
    var openId=that.data.openId;
    wx.request({
      url: app.globalData.defurl + '/weixin/getphone',
      method: 'post',
      data: {
        OpenId: openId,
        encryptedData: e.detail.encryptedData,
        iv: e.detail.iv
      },
      success: function (res) {
        if (res.data.code == 1) {
          that.wxFastLogin(res.data.data)
        } else {
          that.wxFastLoginFail();
        }
      },
      fail() {
        that.wxFastLoginFail();
      }
    })
  } ,
  wxFastLogin(res){
    var that=this;
    var phone = res.Phone;
    var openId = res.OpenId;
    wx.request({
      url: app.globalData.defurl + '/WeiXin/WxRegister',
      method: 'post',
      data: {
        phone,
        openId,
      },
      success: function (res) {
        if(res.data.code==1){
          wx.hideLoading();
          const weburl = encodeURIComponent(that.data.defurl + '/weixin/QRCode&&from=wx&url=/WeiXin/WxLogin?token=' + res.data.data+'&url=' + that.data.paramsUrl + '&name=' + that.data.name);
            wx.redirectTo({
            url: '/pages/index?weburl=' + weburl
          })
        }else{
          that.wxFastLoginFail();
        }
      },
      fail(){
        that.wxFastLoginFail();
      }
    })
  },
  wxFastLoginFail(){
    wx.hideLoading();
    wx.showToast({
      title: '登陆失败',
      icon: 'none',
      duration: 2000
    })
  },
  phoneLogin(){
    const that=this;
    const weburl = encodeURIComponent(that.data.defurl + '/weixin/QRCode&&from=wx&url=/user/login?showpage=show&url=' + that.data.paramsUrl + '&name=' + that.data.name);
    wx.redirectTo({
      url: '/pages/index?weburl=' + weburl
    })
  },
  toIndex(){
    const that = this;
    const weburl = encodeURIComponent(that.data.defurl + '/weixin/QRCode&&from=wx&url=/?&url=' + that.data.paramsUrl + '&name=' + that.data.name);
    wx.redirectTo({
      url: '/pages/index?weburl=' + weburl
    })
  },
  // 打开隐私协议页面
  openPrivacyContract() {
    wx.openPrivacyContract({
      fail: () => {
        wx.showToast({
          title: '遇到错误',
          icon: 'error'
        })
      }
    })
  },
  // 拒绝隐私协议
  exitMiniProgram() {
    // 直接退出小程序
    wx.exitMiniProgram();
  },
  handleAgreePrivacyAuthorization() {
    // 用户点击同意按钮后
    this.setData({
      showPrivacy: false
    })
    // 用户点击同意后，开发者调用 resolve({ buttonId: 'agree-btn', event: 'agree' })  告知平台用户已经同意，参数传同意按钮的id
    // 用户点击拒绝后，开发者调用 resolve({ event:'disagree' }) 告知平台用户已经拒绝
  }
  // onShareAppMessage: function () {
  
  // }
})