//index.js
//获取应用实例
const app = getApp();
Page({
  data: {
    url: '',
    userInfo:'',
    defurl: app.globalData.defurl
  }, 
  //测试：https://wxpreprod.edstao.com
  //正式：https://wxapplets.edstao.com
  onLoad: function (options) {
    let weburl = decodeURIComponent(options.weburl);
    var userInfo='';
    wx.login({
      success:res=>{
        var code=res.code;
        if (weburl != 'undefined') {
          weburl = weburl.replace('&&', '?');
          if(weburl.indexOf('#')>-1){
            weburl = weburl.replace('#', 'SPECIAL');
          }
          userInfo = this.getQueryObject(weburl).name;
          this.setData({ url: weburl + '&code=' + code, userInfo: this.getQueryObject(weburl).name });
        } else {
            var name = options.scene|| '';
            userInfo = name;
            this.setData({ url: this.data.defurl + '/weixin/QRCode?t='+new Date().getTime()+'&name='+ name + '&code=' + code, userInfo: name });
            if (!name) {
              // this.setData({url:"https://etaoh5dz-pre.edstao.com"})
              this.getwxsession()
            }
        }
        if (userInfo){
          app.globalData.userInfo = userInfo;
        }
      }
    })
   
  },
  getwxsession(){
    var that=this;
    wx.login({
      success: res => {
        var code = res.code;
        wx.request({
          url: app.globalData.defurl + '/weixin/wxsession',
          data: {
            code: code
          },
          success: function (res) {
            if (res.data.code==1){
              app.globalData.userInfo = res.data.domainName;
              that.setData({ url: that.data.defurl + '/weixin/QRCode?t='+new Date().getTime()+'&name='+ res.data.domainName + '&code=' + code, userInfo: res.data.domainName });
            }
          }
        })
      }
    })
  },
  getQueryObject:function (url) {
    url = url == null ? window.location.href : url;
    var search = url.substring(url.lastIndexOf("?") + 1);
    var obj = {};
    var reg = /([^?&=]+)=([^?&=]*)/g;
    search.replace(reg, function (rs, $1, $2) {
      var name = decodeURIComponent($1);
      var val = decodeURIComponent($2);
      val = String(val);
      obj[name] = val;
      return rs;
    });
    return obj;
  },
  bindGetMsg: function (e) {
    var res = e.detail.data;
    if (res.length != 0){
      var arr = res.pop();
      this.setData({
        imgUrl: arr.imgUrl,
        proName: arr.proName 
      }) 
    }
  },
  onShareAppMessage: function (options) {
    let that = this;
    let data = that.data;
    let newUrl = options.webViewUrl.replace(data.defurl, '');
    let title = data.proName ? data.proName : '商城';
    let time =new Date().getTime()
    let imageUrl = data.imgUrl ? data.imgUrl : 'https://img.edsmall.com/ROOT/ETao/fenxiao/h5/share-bg.png?t='+time
    const weburl = encodeURIComponent(data.defurl + '/weixin/QRCode&&from=wx&url=' + newUrl + '&name=' + data.userInfo);
    return {
      title: title,
      desc: '',
      path: '/pages/index?weburl=' + weburl,
      imageUrl: imageUrl
    }
   
  }
})
