//index.js
//获取应用实例
const app = getApp();

Page({
  data: {
    userInfo:'',
    OrderMain:{},
    OrderDetail:[],
    defurl: app.globalData.defurl
  },  
  onLoad: function (options) {
    var that = this;
    if(options.orderid){
      that.setData({ userInfo: options.wxapplets?options.wxapplets:''})
      that.getOrder(options.orderid)
    }else{
      wx.redirectTo({
        url:'/pages/index'
      })
    }
  },
  getOrder:function(orderId){
    var that = this;
    wx.request({
      url: that.data.defurl + '/pay/postdetail',
      data:{orderid:orderId},
      header: {
        'content-type': 'application/json' // 默认值
      },
      success: function (res) {
        //生成页面数据
        that.setData({ OrderMain: res.data.OrderMain, OrderDetail: res.data.OrderDetail})
      }
    })
  },  
  payMoney: function () {
    const that = this;
    wx.login({
      success: function (res) {
        wx.request({
          url: that.data.defurl + '/weixin/openid',
          data: {
            code:res.code
          },
          method: 'GET',
          header: { 'content-type': 'application/json' },
          success: function (res) {
            that.getPay(res.data.openid, that.data.OrderMain.orderId)
          }
        })
      }
    })
  },
  getPay: function (openid, orderid ) {
    wx.showLoading({
      title: '加载中...',
      mask:true
    })
    let that = this;
    wx.request({
      url: this.data.defurl+'/pay/WxMiniProgramPayParam',
      method:'POST',
      data:{
        orderId: orderid,
        openId: openid
      },
      success(res){
        wx.hideLoading();
        if(res.data.code==1){
          var data=res.data;
          wx.requestPayment({
            timeStamp: data.timeStamp,
            nonceStr: data.nonceStr,
            package: data.package,
            signType: data.signType,
            paySign: data.paySign,
            success(res) { 
              let newUrl = '/order/list';
              const weburl = encodeURIComponent(that.data.defurl + '/weixin/QRCode&&from=wx&url=' + newUrl + '&name=' + that.data.userInfo);
              wx.redirectTo({
                url: '/pages/index?weburl=' + weburl
              })
            },
            fail(res) { 
              wx.showToast({
                title: '支付失败',
                icon:"none",
                duration:3000
              })
            }
          })
        }else{
          wx.showToast({
            title: '支付失败',
            icon: "none",
            duration: 3000
          })
        }
      }
    })
   
  },
  cancel:function(){
    let that = this;
    let newUrl = '/order/list?l=全部';
    newUrl = encodeURIComponent(newUrl);
    const weburl = encodeURIComponent(that.data.defurl + '/weixin/QRCode&&name=' + that.data.userInfo + '&from=wx&url=' + newUrl);
    wx.redirectTo({
      url: '/pages/index?weburl=' + weburl
    })
  }
 
  
})
