"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createConfig = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const uni_cli_shared_1 = require("@dcloudio/uni-cli-shared");
const css_1 = require("./css");
const resolve_1 = require("./resolve");
const build_1 = require("./build");
const optimizeDeps_1 = require("./optimizeDeps");
const define_1 = require("./define");
function createConfig(options, _uniPlugins) {
    return (config, env) => {
        options.command = env.command;
        let base = config.base;
        if (!base) {
            const { h5 } = (0, uni_cli_shared_1.parseManifestJsonOnce)(options.inputDir);
            base = (h5 && h5.router && h5.router.base) || '';
        }
        if (!base) {
            base = '/';
        }
        options.base = base;
        return {
            base: process.env.UNI_H5_BASE || base,
            root: process.env.VITE_ROOT_DIR,
            // TODO 临时设置为__static__,屏蔽警告：https://github.com/vitejs/vite/blob/824d042535033a5c3d7006978c0d05c201cd1c25/packages/vite/src/node/server/middlewares/transform.ts#L125
            publicDir: config.publicDir || '__static__',
            define: (0, define_1.createDefine)(options),
            resolve: (0, resolve_1.createResolve)(options, config),
            logLevel: config.logLevel || 'warn',
            optimizeDeps: (0, optimizeDeps_1.createOptimizeDeps)(options),
            build: (0, build_1.createBuild)(options, config),
            css: (0, css_1.createCss)(options, config),
            worker: {
                plugins: initFixedEsbuildInitTSConfck(process.env.UNI_INPUT_DIR),
            },
            plugins: initFixedEsbuildInitTSConfck(process.env.UNI_NODE_ENV),
        };
    };
}
exports.createConfig = createConfig;
/**
 * 解决 HBuilderX 项目未包含 package.json 时，initTSConfck 可能导致查找过慢，或递归目录时权限不足报错
 * 即：未包含 package.json 时，直接移除 initTSConfck 相关逻辑
 * @param inputDir
 * @returns
 */
function initFixedEsbuildInitTSConfck(inputDir) {
    if (!(0, uni_cli_shared_1.isInHBuilderX)()) {
        return [];
    }
    if (fs_1.default.existsSync(path_1.default.resolve(inputDir, 'package.json'))) {
        return [];
    }
    const initTSConfckPlugins = ['vite:esbuild', 'vite:esbuild-transpile'];
    return [
        {
            name: 'fixed-esbuild-initTSConfck',
            enforce: 'pre',
            configResolved(config) {
                initTSConfckPlugins.forEach((name) => {
                    const plugin = config.worker.plugins.find((p) => p.name === name);
                    if (plugin) {
                        delete plugin.configResolved;
                    }
                });
            },
        },
    ];
}
