"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.initModulePaths = exports.runByHBuilderX = exports.isInHBuilderX = void 0;
const path_1 = __importDefault(require("path"));
const module_1 = __importDefault(require("module"));
const uni_shared_1 = require("@dcloudio/uni-shared");
exports.isInHBuilderX = (0, uni_shared_1.once)(() => {
    try {
        const { name } = require(path_1.default.resolve(process.cwd(), '../about/package.json'));
        if (name === 'about') {
            process.env.UNI_HBUILDERX_PLUGINS = path_1.default.resolve(process.cwd(), '..');
            return true;
        }
    }
    catch (e) {
        // console.error(e)
    }
    return false;
});
exports.runByHBuilderX = (0, uni_shared_1.once)(() => {
    return !!process.env.UNI_HBUILDERX_PLUGINS;
});
/**
 * 增加 node_modules
 */
function initModulePaths() {
    if (!(0, exports.isInHBuilderX)()) {
        return;
    }
    const Module = module.constructor.length > 1 ? module.constructor : module_1.default;
    const nodeModulesPath = path_1.default.resolve(process.env.UNI_CLI_CONTEXT, 'node_modules');
    const oldNodeModulePaths = Module._nodeModulePaths;
    Module._nodeModulePaths = function (from) {
        const paths = oldNodeModulePaths.call(this, from);
        if (!paths.includes(nodeModulesPath)) {
            paths.push(nodeModulesPath);
        }
        return paths;
    };
}
exports.initModulePaths = initModulePaths;
