"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getDevServerOptions = exports.isEnableTreeShaking = exports.getRouterOptions = exports.isUniPushOffline = exports.isEnableUniPushV2 = exports.getUniStatistics = exports.normalizeNetworkTimeout = exports.parseCompatConfigOnce = exports.parseRpx2UnitOnce = exports.parseManifestJsonOnce = exports.parseManifestJson = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const shared_1 = require("@vue/shared");
const uni_shared_1 = require("@dcloudio/uni-shared");
const json_1 = require("./json");
const parseManifestJson = (inputDir) => {
    return (0, json_1.parseJson)(fs_1.default.readFileSync(path_1.default.join(inputDir, 'manifest.json'), 'utf8'));
};
exports.parseManifestJson = parseManifestJson;
exports.parseManifestJsonOnce = (0, uni_shared_1.once)(exports.parseManifestJson);
exports.parseRpx2UnitOnce = (0, uni_shared_1.once)((inputDir, platform = 'h5') => {
    const rpx2unit = platform === 'h5' || platform === 'app'
        ? uni_shared_1.defaultRpx2Unit
        : uni_shared_1.defaultMiniProgramRpx2Unit;
    const platformOptions = (0, exports.parseManifestJsonOnce)(inputDir)[platform];
    if (platformOptions && platformOptions.rpx) {
        return (0, shared_1.extend)({}, rpx2unit, platformOptions);
    }
    return (0, shared_1.extend)({}, rpx2unit);
});
function parseCompatConfig(_inputDir) {
    // 不支持 mode:2
    return { MODE: 3 }; //parseManifestJsonOnce(inputDir).compatConfig || {}
}
exports.parseCompatConfigOnce = (0, uni_shared_1.once)(parseCompatConfig);
const defaultNetworkTimeout = {
    request: 60000,
    connectSocket: 60000,
    uploadFile: 60000,
    downloadFile: 60000,
};
function normalizeNetworkTimeout(networkTimeout) {
    return {
        ...defaultNetworkTimeout,
        ...networkTimeout,
    };
}
exports.normalizeNetworkTimeout = normalizeNetworkTimeout;
function getUniStatistics(inputDir, platform) {
    const manifest = (0, exports.parseManifestJsonOnce)(inputDir);
    return (0, shared_1.extend)({}, manifest.uniStatistics, manifest[platform] && manifest[platform].uniStatistics);
}
exports.getUniStatistics = getUniStatistics;
function isEnableUniPushV2(inputDir, platform) {
    var _a, _b, _c, _d, _e, _f, _g;
    const manifest = (0, exports.parseManifestJsonOnce)(inputDir);
    if (platform === 'app') {
        return (((_e = (_d = (_c = (_b = (_a = manifest['app-plus']) === null || _a === void 0 ? void 0 : _a.distribute) === null || _b === void 0 ? void 0 : _b.sdkConfigs) === null || _c === void 0 ? void 0 : _c.push) === null || _d === void 0 ? void 0 : _d.unipush) === null || _e === void 0 ? void 0 : _e.version) ==
            '2');
    }
    return ((_g = (_f = manifest[platform]) === null || _f === void 0 ? void 0 : _f.unipush) === null || _g === void 0 ? void 0 : _g.enable) === true;
}
exports.isEnableUniPushV2 = isEnableUniPushV2;
function isUniPushOffline(inputDir) {
    var _a, _b, _c, _d, _e;
    const manifest = (0, exports.parseManifestJsonOnce)(inputDir);
    return (((_e = (_d = (_c = (_b = (_a = manifest['app-plus']) === null || _a === void 0 ? void 0 : _a.distribute) === null || _b === void 0 ? void 0 : _b.sdkConfigs) === null || _c === void 0 ? void 0 : _c.push) === null || _d === void 0 ? void 0 : _d.unipush) === null || _e === void 0 ? void 0 : _e.offline) ===
        true);
}
exports.isUniPushOffline = isUniPushOffline;
function getRouterOptions(manifestJson) {
    var _a;
    return (0, shared_1.extend)({}, (_a = manifestJson.h5) === null || _a === void 0 ? void 0 : _a.router);
}
exports.getRouterOptions = getRouterOptions;
function isEnableTreeShaking(manifestJson) {
    var _a, _b, _c;
    return ((_c = (_b = (_a = manifestJson.h5) === null || _a === void 0 ? void 0 : _a.optimization) === null || _b === void 0 ? void 0 : _b.treeShaking) === null || _c === void 0 ? void 0 : _c.enable) !== false;
}
exports.isEnableTreeShaking = isEnableTreeShaking;
function getDevServerOptions(manifestJson) {
    var _a;
    return (0, shared_1.extend)({}, (_a = manifestJson.h5) === null || _a === void 0 ? void 0 : _a.devServer);
}
exports.getDevServerOptions = getDevServerOptions;
