"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.mergeMiniProgramAppJson = exports.parseMiniProgramPagesJson = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
const shared_1 = require("@vue/shared");
const json_1 = require("../json");
const pages_1 = require("../pages");
const utils_1 = require("./utils");
const utils_2 = require("../../utils");
const project_1 = require("./project");
function parseMiniProgramPagesJson(jsonStr, platform, options = { subpackages: false }) {
    return parsePagesJson(jsonStr, platform, options);
}
exports.parseMiniProgramPagesJson = parseMiniProgramPagesJson;
function mergeMiniProgramAppJson(appJson, platformJson = {}) {
    Object.keys(platformJson).forEach((name) => {
        if (!(0, project_1.isMiniProgramProjectJsonKey)(name) &&
            ![
                'unipush',
                'usingComponents',
                'optimization',
                'scopedSlotsCompiler',
            ].includes(name)) {
            appJson[name] = platformJson[name];
        }
    });
}
exports.mergeMiniProgramAppJson = mergeMiniProgramAppJson;
function parsePagesJson(jsonStr, platform, { debug, darkmode, networkTimeout, subpackages, windowOptionsMap, tabBarOptionsMap, tabBarItemOptionsMap, } = {
    subpackages: false,
}) {
    const appJson = {
        pages: [],
    };
    const pageJsons = {};
    const nvuePages = [];
    // preprocess
    const pagesJson = (0, json_1.parseJson)(jsonStr, true);
    if (!pagesJson) {
        throw new Error(`[vite] Error: pages.json parse failed.\n`);
    }
    function addPageJson(pagePath, style) {
        const filename = path_1.default.join(process.env.UNI_INPUT_DIR, pagePath);
        if (fs_1.default.existsSync(filename + '.nvue') &&
            !fs_1.default.existsSync(filename + '.vue')) {
            nvuePages.push(pagePath);
        }
        const windowOptions = {};
        if (platform === 'mp-baidu') {
            // 仅百度小程序需要页面配置 component:true
            // 快手小程序反而不能配置 component:true，故不能统一添加，目前硬编码处理
            windowOptions.component = true;
        }
        pageJsons[pagePath] = (0, shared_1.extend)(windowOptions, (0, utils_1.parseWindowOptions)(style, platform, windowOptionsMap));
    }
    // pages
    (0, pages_1.validatePages)(pagesJson, jsonStr);
    pagesJson.pages.forEach((page) => {
        appJson.pages.push(page.path);
        addPageJson(page.path, page.style);
    });
    // subpackages
    pagesJson.subPackages = pagesJson.subPackages || pagesJson.subpackages;
    if (pagesJson.subPackages) {
        if (subpackages) {
            appJson.subPackages = pagesJson.subPackages.map(({ root, pages, ...rest }) => {
                return (0, shared_1.extend)({
                    root,
                    pages: pages.map((page) => {
                        addPageJson((0, utils_2.normalizePath)(path_1.default.join(root, page.path)), page.style);
                        return page.path;
                    }),
                }, rest);
            });
        }
        else {
            pagesJson.subPackages.forEach(({ root, pages }) => {
                pages.forEach((page) => {
                    const pagePath = (0, utils_2.normalizePath)(path_1.default.join(root, page.path));
                    appJson.pages.push(pagePath);
                    addPageJson(pagePath, page.style);
                });
            });
        }
    }
    // window
    if (pagesJson.globalStyle) {
        const windowOptions = (0, utils_1.parseWindowOptions)(pagesJson.globalStyle, platform, windowOptionsMap);
        const { usingComponents } = windowOptions;
        if (usingComponents) {
            delete windowOptions.usingComponents;
            appJson.usingComponents = usingComponents;
        }
        else {
            delete appJson.usingComponents;
        }
        appJson.window = windowOptions;
    }
    // tabBar
    if (pagesJson.tabBar) {
        const tabBar = (0, utils_1.parseTabBar)(pagesJson.tabBar, platform, tabBarOptionsMap, tabBarItemOptionsMap);
        if (tabBar) {
            appJson.tabBar = tabBar;
        }
    }
    ;
    ['preloadRule', 'workers', 'plugins'].forEach((name) => {
        if ((0, shared_1.hasOwn)(pagesJson, name)) {
            appJson[name] = pagesJson[name];
        }
    });
    if (debug) {
        appJson.debug = debug;
    }
    if (networkTimeout) {
        appJson.networkTimeout = networkTimeout;
    }
    if (darkmode) {
        appJson.darkmode = true;
        appJson.themeLocation = 'theme.json';
    }
    return {
        appJson,
        pageJsons,
        nvuePages,
    };
}
