"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createCss = void 0;
const path_1 = __importDefault(require("path"));
const fs_extra_1 = __importDefault(require("fs-extra"));
function resolveAdditionalData(inputDir, config) {
    var _a, _b, _c;
    const uniScssFile = path_1.default.resolve(inputDir, 'uni.scss');
    const userAdditionalData = ((_c = (_b = (_a = config.css) === null || _a === void 0 ? void 0 : _a.preprocessorOptions) === null || _b === void 0 ? void 0 : _b.scss) === null || _c === void 0 ? void 0 : _c.additionalData) || '';
    if (!fs_extra_1.default.existsSync(uniScssFile)) {
        return userAdditionalData;
    }
    return fs_extra_1.default.readFileSync(uniScssFile, 'utf8') + '\n' + userAdditionalData;
}
function createCss(options, config) {
    return {
        preprocessorOptions: {
            scss: {
                charset: false,
                additionalData: resolveAdditionalData(options.inputDir, config),
            },
        },
    };
}
exports.createCss = createCss;
