"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.rewriteCompilerSfcParse = void 0;
const path_1 = __importDefault(require("path"));
const uni_cli_shared_1 = require("@dcloudio/uni-cli-shared");
/**
 * TODO 临时重写，解决 @vitejs/plugin-vue 的 Bug
 */
function rewriteCompilerSfcParse() {
    // @ts-ignore
    const compilerSfc = require((0, uni_cli_shared_1.resolveBuiltIn)('@vue/compiler-sfc'));
    const { parse } = compilerSfc;
    compilerSfc.parse = (source, options) => {
        if (options === null || options === void 0 ? void 0 : options.filename) {
            const extname = path_1.default.extname(options.filename);
            // wxs、filter、renderjs
            if (extname && !uni_cli_shared_1.EXTNAME_VUE.includes(extname)) {
                const tag = extname.slice(1);
                source = `<${tag}>` + source + `</${tag}>`;
            }
        }
        return parse(source, options);
    };
}
exports.rewriteCompilerSfcParse = rewriteCompilerSfcParse;
