"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.checkInstallPackage = void 0;
// eslint-disable-next-line @typescript-eslint/ban-types
function checkInstallPackage(pkg, debug) {
    let installedVueI18n = false;
    try {
        debug(`vue-i18n load path: ${require.resolve('vue-i18n')}`);
        installedVueI18n = true;
    }
    catch (e) {
        debug(`cannot find 'vue-i18n'`, e);
    }
    let installedPetiteVueI18n = false;
    try {
        debug(`petite-vue-i18n load path: ${require.resolve('petite-vue-i18n')}`);
        installedPetiteVueI18n = true;
    }
    catch (e) {
        debug(`cannot find 'petite-vue-i18n'`, e);
    }
    if (installedVueI18n) {
        return 'vue-i18n';
    }
    if (installedPetiteVueI18n) {
        return 'petite-vue-i18n';
    }
    throw new Error(`${pkg} requires 'vue-i18n' or 'petite-vue-i18n' to be present in the dependency tree.`);
}
exports.checkInstallPackage = checkInstallPackage;
