var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stdin_exports = {};
__export(stdin_exports, {
  default: () => stdin_default
});
module.exports = __toCommonJS(stdin_exports);
var import_vue = require("vue");
var import_vue2 = require("vue");
var import_utils = require("../utils");
var import_icon = require("../icon");
const [name, bem] = (0, import_utils.createNamespace)("image");
const imageProps = {
  src: String,
  alt: String,
  fit: String,
  position: String,
  round: Boolean,
  width: import_utils.numericProp,
  height: import_utils.numericProp,
  radius: import_utils.numericProp,
  lazyLoad: Boolean,
  iconSize: import_utils.numericProp,
  showError: import_utils.truthProp,
  errorIcon: (0, import_utils.makeStringProp)("photo-fail"),
  iconPrefix: String,
  showLoading: import_utils.truthProp,
  loadingIcon: (0, import_utils.makeStringProp)("photo")
};
var stdin_default = (0, import_vue2.defineComponent)({
  name,
  props: imageProps,
  emits: ["load", "error"],
  setup(props, {
    emit,
    slots
  }) {
    const error = (0, import_vue2.ref)(false);
    const loading = (0, import_vue2.ref)(true);
    const imageRef = (0, import_vue2.ref)();
    const {
      $Lazyload
    } = (0, import_vue2.getCurrentInstance)().proxy;
    const style = (0, import_vue2.computed)(() => {
      const style2 = {
        width: (0, import_utils.addUnit)(props.width),
        height: (0, import_utils.addUnit)(props.height)
      };
      if ((0, import_utils.isDef)(props.radius)) {
        style2.overflow = "hidden";
        style2.borderRadius = (0, import_utils.addUnit)(props.radius);
      }
      return style2;
    });
    (0, import_vue2.watch)(() => props.src, () => {
      error.value = false;
      loading.value = true;
    });
    const onLoad = (event) => {
      loading.value = false;
      emit("load", event);
    };
    const onError = (event) => {
      error.value = true;
      loading.value = false;
      emit("error", event);
    };
    const renderIcon = (name2, className, slot) => {
      if (slot) {
        return slot();
      }
      return (0, import_vue.createVNode)(import_icon.Icon, {
        "name": name2,
        "size": props.iconSize,
        "class": className,
        "classPrefix": props.iconPrefix
      }, null);
    };
    const renderPlaceholder = () => {
      if (loading.value && props.showLoading) {
        return (0, import_vue.createVNode)("div", {
          "class": bem("loading")
        }, [renderIcon(props.loadingIcon, bem("loading-icon"), slots.loading)]);
      }
      if (error.value && props.showError) {
        return (0, import_vue.createVNode)("div", {
          "class": bem("error")
        }, [renderIcon(props.errorIcon, bem("error-icon"), slots.error)]);
      }
    };
    const renderImage = () => {
      if (error.value || !props.src) {
        return;
      }
      const attrs = {
        alt: props.alt,
        class: bem("img"),
        style: {
          objectFit: props.fit,
          objectPosition: props.position
        }
      };
      if (props.lazyLoad) {
        return (0, import_vue.withDirectives)((0, import_vue.createVNode)("img", (0, import_vue.mergeProps)({
          "ref": imageRef
        }, attrs), null), [[(0, import_vue.resolveDirective)("lazy"), props.src]]);
      }
      return (0, import_vue.createVNode)("img", (0, import_vue.mergeProps)({
        "src": props.src,
        "onLoad": onLoad,
        "onError": onError
      }, attrs), null);
    };
    const onLazyLoaded = ({
      el
    }) => {
      const check = () => {
        if (el === imageRef.value && loading.value) {
          onLoad();
        }
      };
      if (imageRef.value) {
        check();
      } else {
        (0, import_vue2.nextTick)(check);
      }
    };
    const onLazyLoadError = ({
      el
    }) => {
      if (el === imageRef.value && !error.value) {
        onError();
      }
    };
    if ($Lazyload && import_utils.inBrowser) {
      $Lazyload.$on("loaded", onLazyLoaded);
      $Lazyload.$on("error", onLazyLoadError);
      (0, import_vue2.onBeforeUnmount)(() => {
        $Lazyload.$off("loaded", onLazyLoaded);
        $Lazyload.$off("error", onLazyLoadError);
      });
    }
    return () => {
      var _a;
      return (0, import_vue.createVNode)("div", {
        "class": bem({
          round: props.round
        }),
        "style": style.value
      }, [renderImage(), renderPlaceholder(), (_a = slots.default) == null ? void 0 : _a.call(slots)]);
    };
  }
});
