import request from "@/common/request";

export default {
  accountInfo(data: any) {
    return request({
      url: "/api/account/info",
      data,
    });
  },
  setHeadImage(data: any) {
    return request({
      url: "/api/account/info/setHeadImage",
      method: 'POST',
      data,
    });
  },
  bindName(data: any) {
    return request({
      url: "/api/account/info/bindName",
      method: 'POST',
      data,
    });
  },
  bindEmail(data: any) {
    return request({
      url: "/api/account/info/bindEmail",
      method: 'POST',
      data,
    });
  },
  setSex(data: any) {
    return request({
      url: "/api/account/info/setSex",
      method: 'POST',
      data,
    });
  },
  alterPassword(data: any) {
    return request({
      url: "/api/account/info/alterPassword",
      method: 'POST',
      data,
    });
  },
  logout() {
    return request({
      url: "/api/account/logout",
    });
  },
  receiveList(data: any) {
    return request({
      url: "/api/receive/list",
      data
    });
  },
  receiveAdd(data: any) {
    return request({
      url: "/api/receive/add",
      method: 'POST',
      data,
    });
  },
  receiveEdit(data: any) {
    return request({
      url: "/api/receive/edit",
      method: 'POST',
      data,
    });
  },
  receiveDel(data: any) {
    return request({
      url: "/api/receive/del",
      data
    });
  },
  favProductList(data: any) {
    return request({
      url: "/api/fav/product/list",
      data
    });
  },
  favBrandList(data: any) {
    return request({
      url: "/api/fav/brand/list",
      data
    });
  },
  getOrderCount() {
    return request({
      url: "/api/order/getOrderCount"
    });
  },
};
