import request from "@/common/request";

export default {
  getProduct(skuId: string | number, data: any) {
    return request({
      url: "/api/product/" + skuId,
      data
    });
  },
  brandInfo(data: any) {
    return request({
      url: "/api/brand/info",
      data
    });
  },
    wxSign(data: any) {
        return request({
            url: "/api/WeiXin/wxSign?skuId="+data.skuId+'&etaomallId='+data.etaomallId+'&url='+data.url,
            method: 'POST',
        });
    },
  imageDetail(data: any) {
    return request({
      url: "/api/image/detail",
      method: 'POST',
      responseType: 'arraybuffer',
      header: {
        'Content-Type': 'application/json;charset=utf-8'
      },
      data
    });
  },
  pictureAndQrCode(data: any) {
    return request({
      url: "/api/image/pictureAndQrCode",
      method: 'POST',
      responseType: 'arraybuffer',
      data
    });
  },
  imageQrCode(data: any) {
    return request({
      url: "/api/image/qrCode",
      method: 'POST',
      responseType: 'arraybuffer',
      data
    });
  },
  skuImage(data: any) {
    return request({
      url: "/api/image/skuImage",
      method: 'POST',
      responseType: 'arraybuffer',
      data
    });
  },
  handTag(data: any) {
    return request({
      url: "/api/image/handTag",
      method: 'POST',
      responseType: 'arraybuffer',
      data
    });
  },
  traDeManage(data: any) {
    return request({
      url: "/api/user/traDeManage",
      data
    });
  }
};
