"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.emptyDir = void 0;
const fs_1 = __importDefault(require("fs"));
const path_1 = __importDefault(require("path"));
function emptyDir(dir, skip) {
    for (const file of fs_1.default.readdirSync(dir)) {
        if (skip === null || skip === void 0 ? void 0 : skip.includes(file)) {
            continue;
        }
        const abs = path_1.default.resolve(dir, file);
        // baseline is Node 12 so can't use rmSync :(
        if (fs_1.default.lstatSync(abs).isDirectory()) {
            emptyDir(abs);
            fs_1.default.rmdirSync(abs);
        }
        else {
            fs_1.default.unlinkSync(abs);
        }
    }
}
exports.emptyDir = emptyDir;
