"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getAppStyleIsolation = exports.getAppCodeSpliting = exports.getAppRenderer = void 0;
function getAppRenderer(manifestJson) {
    const platformOptions = manifestJson['app-plus'];
    if (platformOptions && platformOptions.renderer === 'native') {
        return 'native';
    }
    return '';
}
exports.getAppRenderer = getAppRenderer;
function getAppCodeSpliting(manifestJson) {
    var _a, _b;
    if (((_b = (_a = manifestJson['app-plus']) === null || _a === void 0 ? void 0 : _a.optimization) === null || _b === void 0 ? void 0 : _b.codeSpliting) === true) {
        return true;
    }
    return false;
}
exports.getAppCodeSpliting = getAppCodeSpliting;
function getAppStyleIsolation(manifestJson) {
    var _a, _b, _c;
    return ((_c = (_b = (_a = manifestJson['app-plus']) === null || _a === void 0 ? void 0 : _a.optimization) === null || _b === void 0 ? void 0 : _b.styleIsolation) !== null && _c !== void 0 ? _c : 'apply-shared');
}
exports.getAppStyleIsolation = getAppStyleIsolation;
