import { createVNode as _createVNode } from "vue";
import { defineComponent } from "vue";
import { t, bem, isImageFile } from "./utils.mjs";
import { isDef, extend, numericProp, getSizeStyle, callInterceptor, makeRequiredProp } from "../utils/index.mjs";
import { Icon } from "../icon/index.mjs";
import { Image } from "../image/index.mjs";
import { Loading } from "../loading/index.mjs";
var stdin_default = defineComponent({
  props: {
    name: numericProp,
    item: makeRequiredProp(Object),
    index: Number,
    imageFit: String,
    lazyLoad: Boolean,
    deletable: Boolean,
    previewSize: [Number, String, Array],
    beforeDelete: Function
  },
  emits: ["delete", "preview"],
  setup(props, {
    emit,
    slots
  }) {
    const renderMask = () => {
      const {
        status,
        message
      } = props.item;
      if (status === "uploading" || status === "failed") {
        const MaskIcon = status === "failed" ? _createVNode(Icon, {
          "name": "close",
          "class": bem("mask-icon")
        }, null) : _createVNode(Loading, {
          "class": bem("loading")
        }, null);
        const showMessage = isDef(message) && message !== "";
        return _createVNode("div", {
          "class": bem("mask")
        }, [MaskIcon, showMessage && _createVNode("div", {
          "class": bem("mask-message")
        }, [message])]);
      }
    };
    const onDelete = (event) => {
      const {
        name,
        item,
        index,
        beforeDelete
      } = props;
      event.stopPropagation();
      callInterceptor(beforeDelete, {
        args: [item, {
          name,
          index
        }],
        done: () => emit("delete")
      });
    };
    const onPreview = () => emit("preview");
    const renderDeleteIcon = () => {
      if (props.deletable && props.item.status !== "uploading") {
        const slot = slots["preview-delete"];
        return _createVNode("div", {
          "role": "button",
          "class": bem("preview-delete", {
            shadow: !slot
          }),
          "tabindex": 0,
          "aria-label": t("delete"),
          "onClick": onDelete
        }, [slot ? slot() : _createVNode(Icon, {
          "name": "cross",
          "class": bem("preview-delete-icon")
        }, null)]);
      }
    };
    const renderCover = () => {
      if (slots["preview-cover"]) {
        const {
          index,
          item
        } = props;
        return _createVNode("div", {
          "class": bem("preview-cover")
        }, [slots["preview-cover"](extend({
          index
        }, item))]);
      }
    };
    const renderPreview = () => {
      const {
        item,
        lazyLoad,
        imageFit,
        previewSize
      } = props;
      if (isImageFile(item)) {
        return _createVNode(Image, {
          "fit": imageFit,
          "src": item.content || item.url,
          "class": bem("preview-image"),
          "width": Array.isArray(previewSize) ? previewSize[0] : previewSize,
          "height": Array.isArray(previewSize) ? previewSize[1] : previewSize,
          "lazyLoad": lazyLoad,
          "onClick": onPreview
        }, {
          default: renderCover
        });
      }
      return _createVNode("div", {
        "class": bem("file"),
        "style": getSizeStyle(props.previewSize)
      }, [_createVNode(Icon, {
        "class": bem("file-icon"),
        "name": "description"
      }, null), _createVNode("div", {
        "class": [bem("file-name"), "van-ellipsis"]
      }, [item.file ? item.file.name : item.url]), renderCover()]);
    };
    return () => _createVNode("div", {
      "class": bem("preview")
    }, [renderPreview(), renderMask(), renderDeleteIcon()]);
  }
});
export {
  stdin_default as default
};
