import { type PropType, type ExtractPropTypes } from 'vue';
import { type Numeric } from '../utils';
export declare type BadgePosition = 'top-left' | 'top-right' | 'bottom-left' | 'bottom-right';
declare const badgeProps: {
    dot: BooleanConstructor;
    max: (NumberConstructor | StringConstructor)[];
    tag: {
        type: PropType<keyof HTMLElementTagNameMap>;
        default: keyof HTMLElementTagNameMap;
    };
    color: StringConstructor;
    offset: PropType<[Numeric, Numeric]>;
    content: (NumberConstructor | StringConstructor)[];
    showZero: {
        type: BooleanConstructor;
        default: true;
    };
    position: {
        type: PropType<BadgePosition>;
        default: BadgePosition;
    };
};
export declare type BadgeProps = ExtractPropTypes<typeof badgeProps>;
declare const _default: import("vue").DefineComponent<{
    dot: BooleanConstructor;
    max: (NumberConstructor | StringConstructor)[];
    tag: {
        type: PropType<keyof HTMLElementTagNameMap>;
        default: keyof HTMLElementTagNameMap;
    };
    color: StringConstructor;
    offset: PropType<[Numeric, Numeric]>;
    content: (NumberConstructor | StringConstructor)[];
    showZero: {
        type: BooleanConstructor;
        default: true;
    };
    position: {
        type: PropType<BadgePosition>;
        default: BadgePosition;
    };
}, () => JSX.Element | undefined, unknown, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, Record<string, any>, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<ExtractPropTypes<{
    dot: BooleanConstructor;
    max: (NumberConstructor | StringConstructor)[];
    tag: {
        type: PropType<keyof HTMLElementTagNameMap>;
        default: keyof HTMLElementTagNameMap;
    };
    color: StringConstructor;
    offset: PropType<[Numeric, Numeric]>;
    content: (NumberConstructor | StringConstructor)[];
    showZero: {
        type: BooleanConstructor;
        default: true;
    };
    position: {
        type: PropType<BadgePosition>;
        default: BadgePosition;
    };
}>>, {
    dot: boolean;
    tag: keyof HTMLElementTagNameMap;
    showZero: boolean;
    position: BadgePosition;
}>;
export default _default;
