"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initTabBar = void 0;
const uni_shared_1 = require("@dcloudio/uni-shared");
const TABBAR_WHITE = 'rgba(255,255,255,0.4)';
const TABBAR_BLACK = 'rgba(0,0,0,0.4)';
function initTabBar(entryPagePath, manifestJson, pagesJson) {
    var _a, _b;
    if (!((_b = (_a = pagesJson.tabBar) === null || _a === void 0 ? void 0 : _a.list) === null || _b === void 0 ? void 0 : _b.length)) {
        return;
    }
    const tabBar = JSON.parse(JSON.stringify(pagesJson.tabBar));
    tabBar.borderStyle = (tabBar.borderStyle === 'white' ? TABBAR_WHITE : TABBAR_BLACK);
    if (!tabBar.selectedColor) {
        tabBar.selectedColor = uni_shared_1.SELECTED_COLOR;
    }
    tabBar.height = `${parseFloat(tabBar.height) || uni_shared_1.TABBAR_HEIGHT}px`;
    // 首页是 tabBar 页面
    const item = tabBar.list.find((page) => page.pagePath === entryPagePath);
    if (item) {
        ;
        tabBar.child = ['lauchwebview'];
        tabBar.selected = tabBar.list.indexOf(item);
    }
    manifestJson.plus.tabBar = tabBar;
}
exports.initTabBar = initTabBar;
