import { defineConfig } from "vite";
import uni from "@dcloudio/vite-plugin-uni";
// https://vitejs.dev/config/

let filePath = ''
let Timestamp = ''
filePath = 'assets/'; //打包文件存放文件夹路径
Timestamp = '.' + new Date().getTime();//时间戳
export default defineConfig({
  plugins: [
    uni()
  ],
    build:{
        rollupOptions: {
            // dir: "dist",
            //打包后文件名
            //  entryFileNames: `${filePath}[name]${Timestamp}.js`,
            output:{ // 输出重构  打包编译后的 文件目录 文件名称 【模块名称.时间戳】
                // 入口文件名
                entryFileNames: `${filePath}[name]${Timestamp}.js`,
                // 块文件名
                chunkFileNames: `${filePath}[name]${Timestamp}.js`,
                // 资源文件名 css 图片等等
                assetFileNames: `${filePath}[name]${Timestamp}.[ext]`
            }
        }
    },
  server: {
    proxy: {
      '^/pre': {
        target: 'https://wxapplets-fl.edstao.com',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/pre/, '')
      },
        '^/api': {
            target: 'https://wxapplets-fl.edstao.com',
            changeOrigin: true,
            rewrite: (path) => path.replace(/^\/pre/, '')
        },
      '^/prod': {
        target: 'https://etaoh5.edstao.com/',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/prod/, '')
      }
    }
  }
});
