import { inBrowser } from "../utils/index.mjs";
import { onDeactivated, onBeforeUnmount } from "vue";
import { onMountedOrActivated } from "@vant/use";
function useVisibilityChange(target, onChange) {
  if (!inBrowser || !window.IntersectionObserver) {
    return;
  }
  const observer = new IntersectionObserver((entries) => {
    onChange(entries[0].intersectionRatio > 0);
  }, { root: document.body });
  const observe = () => {
    if (target.value) {
      observer.observe(target.value);
    }
  };
  const unobserve = () => {
    if (target.value) {
      observer.unobserve(target.value);
    }
  };
  onDeactivated(unobserve);
  onBeforeUnmount(unobserve);
  onMountedOrActivated(observe);
}
export {
  useVisibilityChange
};
