import { createVNode as _createVNode } from "vue";
import { defineComponent } from "vue";
import { getSizeStyle, makeStringProp, createNamespace } from "../utils/index.mjs";
import { renderError, renderSearch, renderNetwork, renderMaterial } from "./Images.mjs";
const [name, bem] = createNamespace("empty");
const PRESET_IMAGES = {
  error: renderError,
  search: renderSearch,
  network: renderNetwork,
  default: renderMaterial
};
const emptyProps = {
  image: makeStringProp("default"),
  imageSize: [Number, String, Array],
  description: String
};
var stdin_default = defineComponent({
  name,
  props: emptyProps,
  setup(props, {
    slots
  }) {
    const renderImage = () => {
      var _a;
      if (slots.image) {
        return slots.image();
      }
      return ((_a = PRESET_IMAGES[props.image]) == null ? void 0 : _a.call(PRESET_IMAGES)) || _createVNode("img", {
        "src": props.image
      }, null);
    };
    const renderDescription = () => {
      const description = slots.description ? slots.description() : props.description;
      if (description) {
        return _createVNode("p", {
          "class": bem("description")
        }, [description]);
      }
    };
    const renderBottom = () => {
      if (slots.default) {
        return _createVNode("div", {
          "class": bem("bottom")
        }, [slots.default()]);
      }
    };
    return () => _createVNode("div", {
      "class": bem()
    }, [_createVNode("div", {
      "class": bem("image"),
      "style": getSizeStyle(props.imageSize)
    }, [renderImage()]), renderDescription(), renderBottom()]);
  }
});
export {
  stdin_default as default
};
