/// <reference types="vite/client" />

declare module "*.vue" {
  import { DefineComponent } from "vue";
  // eslint-disable-next-line @typescript-eslint/no-explicit-any, @typescript-eslint/ban-types
  const component: DefineComponent<{}, {}, any>;
  export default component;
}
// 环境
declare module 'process' {
  global {
    namespace NodeJS {
      interface ProcessUniEnv {
        base_url: string;
        api_url: string;
        subdomain: string;
      }
      interface Process {
        uniEnv: NodeJS.ProcessUniEnv;
      }
    }
  }
}
interface Window {
  _wx: {
    config: (config: unknown) => void;
    error: (config: unknown) => any;
    ready: (config: unknown) => void;
    updateAppMessageShareData: (config: unknown) => void;
    updateTimelineShareData: (config: unknown) => void;
  };
  _sha1: Function;
}
