"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initSafearea = void 0;
function initSafearea(manifestJson, pagesJson) {
    var _a, _b;
    if ((_b = (_a = pagesJson.tabBar) === null || _a === void 0 ? void 0 : _a.list) === null || _b === void 0 ? void 0 : _b.length) {
        // 安全区配置 仅包含 tabBar 的时候才配置
        if (!manifestJson.plus.safearea) {
            manifestJson.plus.safearea = {
                background: pagesJson.tabBar.backgroundColor || '#FFFFFF',
                bottom: {
                    offset: 'auto',
                },
            };
        }
    }
    else {
        if (!manifestJson.plus.launchwebview) {
            manifestJson.plus.launchwebview = {
                render: 'always',
            };
        }
        else if (!manifestJson.plus.launchwebview.render) {
            manifestJson.plus.launchwebview.render = 'always';
        }
    }
}
exports.initSafearea = initSafearea;
