import { createVNode as _createVNode } from "vue";
import { defineComponent } from "vue";
import { truthProp, numericProp, makeArrayProp, createNamespace } from "../utils/index.mjs";
import { Button } from "../button/index.mjs";
import { RadioGroup } from "../radio-group/index.mjs";
import AddressListItem from "./AddressListItem.mjs";
const [name, bem, t] = createNamespace("address-list");
const addressListProps = {
  list: makeArrayProp(),
  modelValue: numericProp,
  switchable: truthProp,
  disabledText: String,
  disabledList: makeArrayProp(),
  addButtonText: String,
  defaultTagText: String
};
var stdin_default = defineComponent({
  name,
  props: addressListProps,
  emits: ["add", "edit", "select", "click-item", "edit-disabled", "select-disabled", "update:modelValue"],
  setup(props, {
    slots,
    emit
  }) {
    const renderItem = (item, index, disabled) => {
      const onEdit = () => emit(disabled ? "edit-disabled" : "edit", item, index);
      const onClick = () => emit("click-item", item, index);
      const onSelect = () => {
        emit(disabled ? "select-disabled" : "select", item, index);
        if (!disabled) {
          emit("update:modelValue", item.id);
        }
      };
      return _createVNode(AddressListItem, {
        "key": item.id,
        "address": item,
        "disabled": disabled,
        "switchable": props.switchable,
        "defaultTagText": props.defaultTagText,
        "onEdit": onEdit,
        "onClick": onClick,
        "onSelect": onSelect
      }, {
        bottom: slots["item-bottom"],
        tag: slots.tag
      });
    };
    const renderList = (list, disabled) => {
      if (list) {
        return list.map((item, index) => renderItem(item, index, disabled));
      }
    };
    const renderBottom = () => _createVNode("div", {
      "class": [bem("bottom"), "van-safe-area-bottom"]
    }, [_createVNode(Button, {
      "round": true,
      "block": true,
      "type": "danger",
      "text": props.addButtonText || t("add"),
      "class": bem("add"),
      "onClick": () => emit("add")
    }, null)]);
    return () => {
      var _a, _b;
      const List = renderList(props.list);
      const DisabledList = renderList(props.disabledList, true);
      const DisabledText = props.disabledText && _createVNode("div", {
        "class": bem("disabled-text")
      }, [props.disabledText]);
      return _createVNode("div", {
        "class": bem()
      }, [(_a = slots.top) == null ? void 0 : _a.call(slots), _createVNode(RadioGroup, {
        "modelValue": props.modelValue
      }, {
        default: () => [List]
      }), DisabledText, DisabledList, (_b = slots.default) == null ? void 0 : _b.call(slots), renderBottom()]);
    };
  }
});
export {
  stdin_default as default
};
