import { Toast } from "vant";
import { PageUtils } from "@/utils/utils";
const request = (options) => {
    Toast.loading({
        message: '加载中...',
        forbidClick: true,
        duration: 200
    });
    return new Promise((resolve, reject) => {
        const { token } = uni.getStorageSync("user") || {};
        const header = {
            ...(options.noToken ? undefined : { Authorization: token }),
            ...options.header,
        };
        const url = (options.baseUrl || uni.getStorageSync("uniEnv")?.api_url || "") + options.url;
        if (options.upLoadFile) {
            uni.uploadFile({
                url: url,
                file: options.file,
                name: options.fileKey,
                success: (res) => {
                    const { code, data, message } = JSON.parse(res.data);
                    // 当前使用这个的只有/api/image/upload，但是这个不用鉴权，不会出现401状态
                    if (res.statusCode == 401) {
                        // @ts-ignore
                        const redirect = encodeURIComponent(PageUtils.getCurPage().$page.fullPath);
                        uni.reLaunch({ url: "/pages/login/login?redirect=" + redirect });
                        Toast(message);
                        reject(message);
                    }
                    if (code == 200) {
                        resolve(data);
                    }
                    else {
                        Toast(message);
                        reject(message);
                    }
                },
                fail: (err) => {
                    reject(err);
                },
            });
        }
        else {
            uni.request({
                method: options.method,
                header,
                responseType: options.responseType,
                url,
                data: options.data,
                success: (res) => {
                    const { code, data, message } = res.data;
                    if (res.statusCode == 401) {
                        // @ts-ignore
                        const redirect = encodeURIComponent(PageUtils.getCurPage().$page.fullPath);
                        uni.reLaunch({ url: "/pages/login/login?redirect=" + redirect });
                        Toast(message);
                        reject(message);
                    }
                    if (options.raw) {
                        resolve(res.data);
                    }
                    else if (options.responseType) {
                        resolve(res.data);
                    }
                    else if (code == 200) {
                        resolve(data);
                    }
                    else {
                        Toast(message);
                        reject(message);
                    }
                },
                fail: (err) => {
                    reject(err);
                },
            });
        }
    });
};
export default request;
//# sourceMappingURL=request.js.map