import { defineConfig } from "vite";
import uni from "@dcloudio/vite-plugin-uni";
// https://vitejs.dev/config/
export default defineConfig({
  plugins: [
    uni()
  ],
  server: {
    proxy: {
      '^/pre': {
        target: 'https://wxapplets-fl.edstao.com',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/pre/, '')
      },
        '^/api': {
            target: 'https://wxapplets-fl.edstao.com',
            changeOrigin: true,
            rewrite: (path) => path.replace(/^\/pre/, '')
        },
      '^/prod': {
        target: 'https://etaoh5.edstao.com/',
        changeOrigin: true,
        rewrite: (path) => path.replace(/^\/prod/, '')
      }
    }
  }
});
