"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const debug_1 = __importDefault(require("debug"));
const magic_string_1 = __importDefault(require("magic-string"));
const shared_1 = require("@intlify/shared");
const debug = debug_1.default('vite-plugin-vue-i18n:intlify-vue');
console.warn(`[@intlify/vite-i18n-vue-i18n] IntlifyVue plugin is experimental! This plugin is used for Intlify Devtools. Don't use this plugin to enhancement Component options of your application.`);
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function stringifyObj(obj) {
    return `Object({${Object.keys(obj)
        .map(key => {
        const code = obj[key];
        return `${JSON.stringify(key)}:${toCode(code)}`;
    })
        .join(',')}})`;
}
// eslint-disable-next-line @typescript-eslint/no-explicit-any
function toCode(code) {
    if (code === null) {
        return 'null';
    }
    if (code === undefined) {
        return 'undefined';
    }
    if (shared_1.isString(code)) {
        return JSON.stringify(code);
    }
    if (shared_1.isRegExp(code) && code.toString) {
        return code.toString();
    }
    if (shared_1.isFunction(code) && code.toString) {
        return '(' + code.toString() + ')';
    }
    if (shared_1.isObject(code)) {
        return stringifyObj(code);
    }
    return code + '';
}
function generateCode(values, indentifier, id, config) {
    const injectionCodes = [''];
    Object.keys(values).forEach(key => {
        const code = values[key];
        if (shared_1.isFunction(code)) {
            injectionCodes.push(`${indentifier}.${key} = ${JSON.stringify(code(id, config))}`);
        }
        else {
            injectionCodes.push(`${indentifier}.${key} = ${toCode(code)}`);
        }
    });
    const ret = injectionCodes.join('\n');
    return ret.length > 0 ? `\n${ret}\n` : '';
}
function IntlifyVue(values = {}) {
    let config = null;
    return {
        enforce: 'post',
        name: 'vite-plugin-vue-i18n:intlify-vue',
        configResolved(_config) {
            config = _config;
        },
        transform(code, id) {
            debug('transform', id);
            if (id.endsWith('.vue')) {
                const magic = new magic_string_1.default(code);
                const indentifier = '_sfc_main';
                const index = code.indexOf(`export default ${indentifier}`);
                magic.appendLeft(index, generateCode(values, indentifier, id, config));
                return {
                    code: magic.toString(),
                    map: magic.generateMap()
                };
            }
        }
    };
}
exports.default = IntlifyVue;
