"use strict";
/**
 * Vue SFC Query, forked from the below:
 * - original repository url: https://github.com/vitejs/vite/tree/main/packages/plugin-vue
 * - code url: https://github.com/vitejs/vite/blob/main/packages/plugin-vue/src/utils/query.ts
 * - author: Evan You (https://github.com/yyx990803)
 * - license: MIT
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.parseVueRequest = void 0;
const querystring_1 = __importDefault(require("querystring"));
function parseVueRequest(id) {
    const [filename, rawQuery] = id.split(`?`, 2);
    const query = querystring_1.default.parse(rawQuery);
    const langPart = Object.keys(query).find(key => /lang\./i.test(key));
    if (query.vue != null) {
        query.vue = true;
    }
    if (query.src != null) {
        query.src = true;
    }
    if (query.index != null) {
        query.index = Number(query.index);
    }
    if (query.raw != null) {
        query.raw = true;
    }
    if (langPart) {
        const [, lang] = langPart.split('.');
        query.lang = lang;
    }
    return {
        filename,
        query
    };
}
exports.parseVueRequest = parseVueRequest;
