---
title: Overview
sidebar_label: Overview
pagination_next: null
pagination_prev: null
slug: /
---

`@typescript-eslint/eslint-plugin` includes over 100 rules that detect best practice violations, bugs, and/or stylistic issues specifically for TypeScript code.
See [Configs](/docs/linting/configs) for how to enable recommended rules using configs.

## Supported Rules

<!-- begin base rule list -->

**Key**: :white_check_mark: = recommended, :lock: = strict, :wrench: = fixable, :thought_balloon: = requires type information

| Name                                                                                                         | Description                                                                                                  | :white_check_mark::lock: | :wrench: | :thought_balloon: |
| ------------------------------------------------------------------------------------------------------------ | ------------------------------------------------------------------------------------------------------------ | ------------------------ | -------- | ----------------- |
| [`@typescript-eslint/adjacent-overload-signatures`](./adjacent-overload-signatures.md)                       | Require that member overloads be consecutive                                                                 | :white_check_mark:       |          |                   |
| [`@typescript-eslint/array-type`](./array-type.md)                                                           | Require using either `T[]` or `Array<T>` for arrays                                                          | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/await-thenable`](./await-thenable.md)                                                   | Disallow awaiting a value that is not a Thenable                                                             | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/ban-ts-comment`](./ban-ts-comment.md)                                                   | Disallow `@ts-<directive>` comments or require descriptions after directive                                  | :white_check_mark:       |          |                   |
| [`@typescript-eslint/ban-tslint-comment`](./ban-tslint-comment.md)                                           | Disallow `// tslint:<rule-flag>` comments                                                                    | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/ban-types`](./ban-types.md)                                                             | Disallow certain types                                                                                       | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/class-literal-property-style`](./class-literal-property-style.md)                       | Enforce that literals on classes are exposed in a consistent style                                           | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/consistent-indexed-object-style`](./consistent-indexed-object-style.md)                 | Require or disallow the `Record` type                                                                        | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/consistent-type-assertions`](./consistent-type-assertions.md)                           | Enforce consistent usage of type assertions                                                                  | :lock:                   |          |                   |
| [`@typescript-eslint/consistent-type-definitions`](./consistent-type-definitions.md)                         | Enforce type definitions to consistently use either `interface` or `type`                                    | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/consistent-type-exports`](./consistent-type-exports.md)                                 | Enforce consistent usage of type exports                                                                     |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/consistent-type-imports`](./consistent-type-imports.md)                                 | Enforce consistent usage of type imports                                                                     |                          | :wrench: |                   |
| [`@typescript-eslint/explicit-function-return-type`](./explicit-function-return-type.md)                     | Require explicit return types on functions and class methods                                                 |                          |          |                   |
| [`@typescript-eslint/explicit-member-accessibility`](./explicit-member-accessibility.md)                     | Require explicit accessibility modifiers on class properties and methods                                     |                          | :wrench: |                   |
| [`@typescript-eslint/explicit-module-boundary-types`](./explicit-module-boundary-types.md)                   | Require explicit return and argument types on exported functions' and classes' public class methods          |                          |          |                   |
| [`@typescript-eslint/member-delimiter-style`](./member-delimiter-style.md)                                   | Require a specific member delimiter style for interfaces and type literals                                   |                          | :wrench: |                   |
| [`@typescript-eslint/member-ordering`](./member-ordering.md)                                                 | Require a consistent member declaration order                                                                |                          |          |                   |
| [`@typescript-eslint/method-signature-style`](./method-signature-style.md)                                   | Enforce using a particular method signature syntax                                                           |                          | :wrench: |                   |
| [`@typescript-eslint/naming-convention`](./naming-convention.md)                                             | Enforce naming conventions for everything across a codebase                                                  |                          |          | :thought_balloon: |
| [`@typescript-eslint/no-base-to-string`](./no-base-to-string.md)                                             | Require `.toString()` to only be called on objects which provide useful information when stringified         | :lock:                   |          | :thought_balloon: |
| [`@typescript-eslint/no-confusing-non-null-assertion`](./no-confusing-non-null-assertion.md)                 | Disallow non-null assertion in locations that may be confusing                                               | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/no-confusing-void-expression`](./no-confusing-void-expression.md)                       | Require expressions of type void to appear in statement position                                             |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-duplicate-enum-values`](./no-duplicate-enum-values.md)                               | Disallow duplicate enum member values                                                                        | :lock:                   |          |                   |
| [`@typescript-eslint/no-dynamic-delete`](./no-dynamic-delete.md)                                             | Disallow using the `delete` operator on computed key expressions                                             | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/no-empty-interface`](./no-empty-interface.md)                                           | Disallow the declaration of empty interfaces                                                                 | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/no-explicit-any`](./no-explicit-any.md)                                                 | Disallow the `any` type                                                                                      | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/no-extra-non-null-assertion`](./no-extra-non-null-assertion.md)                         | Disallow extra non-null assertion                                                                            | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/no-extraneous-class`](./no-extraneous-class.md)                                         | Disallow classes used as namespaces                                                                          | :lock:                   |          |                   |
| [`@typescript-eslint/no-floating-promises`](./no-floating-promises.md)                                       | Require Promise-like statements to be handled appropriately                                                  | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-for-in-array`](./no-for-in-array.md)                                                 | Disallow iterating over an array with a for-in loop                                                          | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-inferrable-types`](./no-inferrable-types.md)                                         | Disallow explicit type declarations for variables or parameters initialized to a number, string, or boolean  | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/no-invalid-void-type`](./no-invalid-void-type.md)                                       | Disallow `void` type outside of generic or return types                                                      | :lock:                   |          |                   |
| [`@typescript-eslint/no-meaningless-void-operator`](./no-meaningless-void-operator.md)                       | Disallow the `void` operator except when used to discard a value                                             | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-misused-new`](./no-misused-new.md)                                                   | Enforce valid definition of `new` and `constructor`                                                          | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-misused-promises`](./no-misused-promises.md)                                         | Disallow Promises in places not designed to handle them                                                      | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-namespace`](./no-namespace.md)                                                       | Disallow custom TypeScript modules and namespaces                                                            | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-non-null-asserted-nullish-coalescing`](./no-non-null-asserted-nullish-coalescing.md) | Disallow non-null assertions in the left operand of a nullish coalescing operator                            | :lock:                   |          |                   |
| [`@typescript-eslint/no-non-null-asserted-optional-chain`](./no-non-null-asserted-optional-chain.md)         | Disallow non-null assertions after an optional chain expression                                              | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-non-null-assertion`](./no-non-null-assertion.md)                                     | Disallow non-null assertions using the `!` postfix operator                                                  | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-redundant-type-constituents`](./no-redundant-type-constituents.md)                   | Disallow members of unions and intersections that do nothing or override type information                    |                          |          | :thought_balloon: |
| [`@typescript-eslint/no-require-imports`](./no-require-imports.md)                                           | Disallow invocation of `require()`                                                                           |                          |          |                   |
| [`@typescript-eslint/no-this-alias`](./no-this-alias.md)                                                     | Disallow aliasing `this`                                                                                     | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-type-alias`](./no-type-alias.md)                                                     | Disallow type aliases                                                                                        |                          |          |                   |
| [`@typescript-eslint/no-unnecessary-boolean-literal-compare`](./no-unnecessary-boolean-literal-compare.md)   | Disallow unnecessary equality comparisons against boolean literals                                           | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-unnecessary-condition`](./no-unnecessary-condition.md)                               | Disallow conditionals where the type is always truthy or always falsy                                        | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-unnecessary-qualifier`](./no-unnecessary-qualifier.md)                               | Disallow unnecessary namespace qualifiers                                                                    |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-unnecessary-type-arguments`](./no-unnecessary-type-arguments.md)                     | Disallow type arguments that are equal to the default                                                        | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-unnecessary-type-assertion`](./no-unnecessary-type-assertion.md)                     | Disallow type assertions that do not change the type of an expression                                        | :white_check_mark:       | :wrench: | :thought_balloon: |
| [`@typescript-eslint/no-unnecessary-type-constraint`](./no-unnecessary-type-constraint.md)                   | Disallow unnecessary constraints on generic types                                                            | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-unsafe-argument`](./no-unsafe-argument.md)                                           | Disallow calling a function with a value with type `any`                                                     | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-unsafe-assignment`](./no-unsafe-assignment.md)                                       | Disallow assigning a value with type `any` to variables and properties                                       | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-unsafe-call`](./no-unsafe-call.md)                                                   | Disallow calling a value with type `any`                                                                     | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-unsafe-member-access`](./no-unsafe-member-access.md)                                 | Disallow member access on a value with type `any`                                                            | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-unsafe-return`](./no-unsafe-return.md)                                               | Disallow returning a value with type `any` from a function                                                   | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-useless-empty-export`](./no-useless-empty-export.md)                                 | Disallow empty exports that don't change anything in a module file                                           |                          | :wrench: |                   |
| [`@typescript-eslint/no-var-requires`](./no-var-requires.md)                                                 | Disallow `require` statements except in import statements                                                    | :white_check_mark:       |          |                   |
| [`@typescript-eslint/non-nullable-type-assertion-style`](./non-nullable-type-assertion-style.md)             | Enforce non-null assertions over explicit type casts                                                         | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/parameter-properties`](./parameter-properties.md)                                       | Require or disallow parameter properties in class constructors                                               |                          |          |                   |
| [`@typescript-eslint/prefer-as-const`](./prefer-as-const.md)                                                 | Enforce the use of `as const` over literal type                                                              | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/prefer-enum-initializers`](./prefer-enum-initializers.md)                               | Require each enum member value to be explicitly initialized                                                  |                          |          |                   |
| [`@typescript-eslint/prefer-for-of`](./prefer-for-of.md)                                                     | Enforce the use of `for-of` loop over the standard `for` loop where possible                                 | :lock:                   |          |                   |
| [`@typescript-eslint/prefer-function-type`](./prefer-function-type.md)                                       | Enforce using function types instead of interfaces with call signatures                                      | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/prefer-includes`](./prefer-includes.md)                                                 | Enforce `includes` method over `indexOf` method                                                              | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/prefer-literal-enum-member`](./prefer-literal-enum-member.md)                           | Require all enum members to be literal values                                                                | :lock:                   |          |                   |
| [`@typescript-eslint/prefer-namespace-keyword`](./prefer-namespace-keyword.md)                               | Require using `namespace` keyword over `module` keyword to declare custom TypeScript modules                 | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/prefer-nullish-coalescing`](./prefer-nullish-coalescing.md)                             | Enforce using the nullish coalescing operator instead of logical chaining                                    | :lock:                   |          | :thought_balloon: |
| [`@typescript-eslint/prefer-optional-chain`](./prefer-optional-chain.md)                                     | Enforce using concise optional chain expressions instead of chained logical ands                             | :lock:                   |          |                   |
| [`@typescript-eslint/prefer-readonly`](./prefer-readonly.md)                                                 | Require private members to be marked as `readonly` if they're never modified outside of the constructor      |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/prefer-readonly-parameter-types`](./prefer-readonly-parameter-types.md)                 | Require function parameters to be typed as `readonly` to prevent accidental mutation of inputs               |                          |          | :thought_balloon: |
| [`@typescript-eslint/prefer-reduce-type-parameter`](./prefer-reduce-type-parameter.md)                       | Enforce using type parameter when calling `Array#reduce` instead of casting                                  | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/prefer-regexp-exec`](./prefer-regexp-exec.md)                                           | Enforce `RegExp#exec` over `String#match` if no global flag is provided                                      |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/prefer-return-this-type`](./prefer-return-this-type.md)                                 | Enforce that `this` is used when only `this` type is returned                                                | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/prefer-string-starts-ends-with`](./prefer-string-starts-ends-with.md)                   | Enforce using `String#startsWith` and `String#endsWith` over other equivalent methods of checking substrings | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/prefer-ts-expect-error`](./prefer-ts-expect-error.md)                                   | Enforce using `@ts-expect-error` over `@ts-ignore`                                                           | :lock:                   | :wrench: |                   |
| [`@typescript-eslint/promise-function-async`](./promise-function-async.md)                                   | Require any function or method that returns a Promise to be marked async                                     |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/require-array-sort-compare`](./require-array-sort-compare.md)                           | Require `Array#sort` calls to always provide a `compareFunction`                                             |                          |          | :thought_balloon: |
| [`@typescript-eslint/restrict-plus-operands`](./restrict-plus-operands.md)                                   | Require both operands of addition to have type `number` or `string`                                          | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/restrict-template-expressions`](./restrict-template-expressions.md)                     | Enforce template literal expressions to be of `string` type                                                  | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/sort-type-union-intersection-members`](./sort-type-union-intersection-members.md)       | Enforce members of a type union/intersection to be sorted alphabetically                                     |                          | :wrench: |                   |
| [`@typescript-eslint/strict-boolean-expressions`](./strict-boolean-expressions.md)                           | Disallow certain types in boolean expressions                                                                |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/switch-exhaustiveness-check`](./switch-exhaustiveness-check.md)                         | Require switch-case statements to be exhaustive with union type                                              |                          |          | :thought_balloon: |
| [`@typescript-eslint/triple-slash-reference`](./triple-slash-reference.md)                                   | Disallow certain triple slash directives in favor of ES6-style import declarations                           | :white_check_mark:       |          |                   |
| [`@typescript-eslint/type-annotation-spacing`](./type-annotation-spacing.md)                                 | Require consistent spacing around type annotations                                                           |                          | :wrench: |                   |
| [`@typescript-eslint/typedef`](./typedef.md)                                                                 | Require type annotations in certain places                                                                   |                          |          |                   |
| [`@typescript-eslint/unbound-method`](./unbound-method.md)                                                   | Enforce unbound methods are called with their expected scope                                                 | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/unified-signatures`](./unified-signatures.md)                                           | Disallow two overloads that could be unified into one with a union or an optional/rest parameter             | :lock:                   |          |                   |

<!-- end base rule list -->

## Extension Rules

In some cases, ESLint provides a rule itself, but it doesn't support TypeScript syntax; either it crashes, or it ignores the syntax, or it falsely reports against it.
In these cases, we create what we call an extension rule; a rule within our plugin that has the same functionality, but also supports TypeScript.

<!-- begin extension rule list -->

**Key**: :white_check_mark: = recommended, :lock: = strict, :wrench: = fixable, :thought_balloon: = requires type information

| Name                                                                                         | Description                                                                          | :white_check_mark::lock: | :wrench: | :thought_balloon: |
| -------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------ | ------------------------ | -------- | ----------------- |
| [`@typescript-eslint/brace-style`](./brace-style.md)                                         | Enforce consistent brace style for blocks                                            |                          | :wrench: |                   |
| [`@typescript-eslint/comma-dangle`](./comma-dangle.md)                                       | Require or disallow trailing commas                                                  |                          | :wrench: |                   |
| [`@typescript-eslint/comma-spacing`](./comma-spacing.md)                                     | Enforce consistent spacing before and after commas                                   |                          | :wrench: |                   |
| [`@typescript-eslint/default-param-last`](./default-param-last.md)                           | Enforce default parameters to be last                                                |                          |          |                   |
| [`@typescript-eslint/dot-notation`](./dot-notation.md)                                       | Enforce dot notation whenever possible                                               | :lock:                   | :wrench: | :thought_balloon: |
| [`@typescript-eslint/func-call-spacing`](./func-call-spacing.md)                             | Require or disallow spacing between function identifiers and their invocations       |                          | :wrench: |                   |
| [`@typescript-eslint/indent`](./indent.md)                                                   | Enforce consistent indentation                                                       |                          | :wrench: |                   |
| [`@typescript-eslint/init-declarations`](./init-declarations.md)                             | Require or disallow initialization in variable declarations                          |                          |          |                   |
| [`@typescript-eslint/keyword-spacing`](./keyword-spacing.md)                                 | Enforce consistent spacing before and after keywords                                 |                          | :wrench: |                   |
| [`@typescript-eslint/lines-between-class-members`](./lines-between-class-members.md)         | Require or disallow an empty line between class members                              |                          | :wrench: |                   |
| [`@typescript-eslint/no-array-constructor`](./no-array-constructor.md)                       | Disallow generic `Array` constructors                                                | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/no-dupe-class-members`](./no-dupe-class-members.md)                     | Disallow duplicate class members                                                     |                          |          |                   |
| [`@typescript-eslint/no-empty-function`](./no-empty-function.md)                             | Disallow empty functions                                                             | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-extra-parens`](./no-extra-parens.md)                                 | Disallow unnecessary parentheses                                                     |                          | :wrench: |                   |
| [`@typescript-eslint/no-extra-semi`](./no-extra-semi.md)                                     | Disallow unnecessary semicolons                                                      | :white_check_mark:       | :wrench: |                   |
| [`@typescript-eslint/no-implied-eval`](./no-implied-eval.md)                                 | Disallow the use of `eval()`-like methods                                            | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/no-invalid-this`](./no-invalid-this.md)                                 | Disallow `this` keywords outside of classes or class-like objects                    |                          |          |                   |
| [`@typescript-eslint/no-loop-func`](./no-loop-func.md)                                       | Disallow function declarations that contain unsafe references inside loop statements |                          |          |                   |
| [`@typescript-eslint/no-loss-of-precision`](./no-loss-of-precision.md)                       | Disallow literal numbers that lose precision                                         | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-magic-numbers`](./no-magic-numbers.md)                               | Disallow magic numbers                                                               |                          |          |                   |
| [`@typescript-eslint/no-redeclare`](./no-redeclare.md)                                       | Disallow variable redeclaration                                                      |                          |          |                   |
| [`@typescript-eslint/no-restricted-imports`](./no-restricted-imports.md)                     | Disallow specified modules when loaded by `import`                                   |                          |          |                   |
| [`@typescript-eslint/no-shadow`](./no-shadow.md)                                             | Disallow variable declarations from shadowing variables declared in the outer scope  |                          |          |                   |
| [`@typescript-eslint/no-throw-literal`](./no-throw-literal.md)                               | Disallow throwing literals as exceptions                                             | :lock:                   |          | :thought_balloon: |
| [`@typescript-eslint/no-unused-expressions`](./no-unused-expressions.md)                     | Disallow unused expressions                                                          |                          |          |                   |
| [`@typescript-eslint/no-unused-vars`](./no-unused-vars.md)                                   | Disallow unused variables                                                            | :white_check_mark:       |          |                   |
| [`@typescript-eslint/no-use-before-define`](./no-use-before-define.md)                       | Disallow the use of variables before they are defined                                |                          |          |                   |
| [`@typescript-eslint/no-useless-constructor`](./no-useless-constructor.md)                   | Disallow unnecessary constructors                                                    | :lock:                   |          |                   |
| [`@typescript-eslint/object-curly-spacing`](./object-curly-spacing.md)                       | Enforce consistent spacing inside braces                                             |                          | :wrench: |                   |
| [`@typescript-eslint/padding-line-between-statements`](./padding-line-between-statements.md) | Require or disallow padding lines between statements                                 |                          | :wrench: |                   |
| [`@typescript-eslint/quotes`](./quotes.md)                                                   | Enforce the consistent use of either backticks, double, or single quotes             |                          | :wrench: |                   |
| [`@typescript-eslint/require-await`](./require-await.md)                                     | Disallow async functions which have no `await` expression                            | :white_check_mark:       |          | :thought_balloon: |
| [`@typescript-eslint/return-await`](./return-await.md)                                       | Enforce consistent returning of awaited values                                       |                          | :wrench: | :thought_balloon: |
| [`@typescript-eslint/semi`](./semi.md)                                                       | Require or disallow semicolons instead of ASI                                        |                          | :wrench: |                   |
| [`@typescript-eslint/space-before-blocks`](./space-before-blocks.md)                         | Enforce consistent spacing before blocks                                             |                          | :wrench: |                   |
| [`@typescript-eslint/space-before-function-paren`](./space-before-function-paren.md)         | Enforce consistent spacing before function parenthesis                               |                          | :wrench: |                   |
| [`@typescript-eslint/space-infix-ops`](./space-infix-ops.md)                                 | Require spacing around infix operators                                               |                          | :wrench: |                   |

<!-- end extension rule list -->
