import request from "@/common/request";
export default {
    productFav(data) {
        return request({
            url: "/api/fav/product/fav",
            method: 'POST',
            data
        });
    },
    productDel(data) {
        return request({
            url: "/api/fav/product/del",
            method: 'POST',
            data
        });
    },
    brandFav(data) {
        return request({
            url: "/api/fav/brand/fav",
            method: 'POST',
            data
        });
    },
    brandDel(data) {
        return request({
            url: "/api/fav/brand/del",
            method: 'POST',
            data
        });
    },
    getJsApiTicket() {
        return request({
            url: "/api/wx/getJsApiTicket",
            raw: true
        });
    },
    getWechartConfig(data) {
        return request({
            url: "/php/getWxConfigTest.php",
            method: 'POST',
            data,
            raw: true
        });
    },
    // 不使用该方法，只用有没有优惠价来判断
    isSJS(data) {
        return request({
            url: "/api/user/isSJS",
            data,
        });
    },
    upload(file) {
        return request({
            url: "/api/image/upload",
            upLoadFile: true,
            fileKey: 'image',
            file
        });
    },
    receiveArea() {
        return request({
            url: "/api/receive/area"
        });
    },
};
//# sourceMappingURL=common.js.map