import request from "@/common/request";

export default {
    getCanUse(data: any) {
        return request({
            url: "/api/index/canUse",
            data
        });
    },
    getOrderDetail(data: any) {
        return request({
            url: "/api/order/detail/" + data,
        });
    },
    afterSaleImg() {
        return request({
            url: "/api/order/afterSaleImg/"
        });
    },
    getOrderList(data: any) {
        return request({
            url: "/api/order/list",
            method: 'POST',
            data
        });
    },
    settleInfo(data: any) {
        return request({
            url: "/api/order/settleInfo",
            method: 'POST',
            data
        });
    },
    orderAdd(data: any) {
        return request({
            url: "/api/order/add",
            method: 'POST',
            data
        });
    },
    orderPay(data: any) {
        return request({
            url: "/api/order/pay",
            method: 'POST',
            data
        });
    },
    remindDeliverGoods(data: any) {
        return request({
            url: "/api/order/remindDeliverGoods",
            data,
            noToast: true
        });
    },
    confirmReceipt(data: any) {
        return request({
            url: `/api/order/confirmReceipt/${data.orderId}?domain=${data.domain}`,
        });
    },
    orderCancel(id: any) {
        return request({
            url: "/api/order/cancel/" + id,
        });
    },
    platfromlist() {
        return request({
            url: "/api/channel/platfromlist",
        });
    },
    batchAdd(data: any) {
        return request({
            url: "/api/cart/batchAdd",
            method: 'POST',
            data
        });
    },
};
