import request from "@/common/request";

export default {
  productFav(data: any) {
    return request({
      url: "/api/fav/product/fav",
      method: 'POST',
      data
    });
  },
  productDel(data: any) {
    return request({
      url: "/api/fav/product/del",
      method: 'POST',
      data
    });
  },
  brandFav(data: any) {
    return request({
      url: "/api/fav/brand/fav",
      method: 'POST',
      data
    });
  },
  brandDel(data: any) {
    return request({
      url: "/api/fav/brand/del",
      method: 'POST',
      data
    });
  },
  getJsApiTicket() {
    return request({
      url: "/api/wx/getJsApiTicket",
      raw: true
    });
  },
  getWechartConfig(data: any) {
    return request({
      url: "/php/getWxConfigTest.php",
      method: 'POST',
      data,
      raw: true
    });
  },
  // 不使用该方法，只用有没有优惠价来判断
  isSJS(data: any) {
    return request({
      url: "/api/user/isSJS",
      data,
    });
  },
  upload(file: File) {
    return request({
      url: "/api/image/upload",
      upLoadFile: true,
      fileKey: 'image', // 文件对应的 key , 开发者在服务器端通过这个 key 可以获取到文件二进制内容
      file
    });
  },
  receiveArea() {
    return request({
      url: "/api/receive/area"
    });
  },
};
