import { ResourceNode } from '@intlify/message-compiler';
import { SourceMapGenerator } from 'source-map';
import type { RawSourceMap } from 'source-map';
/**
 * Compilation dev environments
 *
 * @public
 */
export declare type DevEnv = 'development' | 'production';
export interface Position {
    line: number;
    column: number;
    offset?: number;
}
export interface SourceLocationable {
    loc?: {
        start: Position;
        end: Position;
    };
}
/**
 * @internal
 */
export interface CodeGenOptions {
    type?: 'plain' | 'sfc' | 'bare';
    bridge?: boolean;
    source?: string;
    sourceMap?: boolean;
    filename?: string;
    inSourceMap?: RawSourceMap;
    isGlobal?: boolean;
    locale?: string;
    env?: DevEnv;
    forceStringify?: boolean;
    useClassComponent?: boolean;
    onWarn?: (msg: string) => void;
    onError?: (msg: string) => void;
}
export interface CodeGenContext {
    source?: string;
    code: string;
    indentLevel: number;
    filename: string;
    line: number;
    column: number;
    offset: number;
    env: DevEnv;
    forceStringify: boolean;
    map?: SourceMapGenerator;
}
export interface CodeGenerator {
    context(): CodeGenContext;
    push<Node extends SourceLocationable>(code: string, node?: Node, name?: string): void;
    indent(withNewLine?: boolean): void;
    deindent(withNewLine?: boolean): void;
    newline(): void;
    pushline<Node extends SourceLocationable>(code: string, node?: Node, name?: string): void;
}
/**
 * @internal
 */
export interface CodeGenResult<ASTNode> {
    code: string;
    ast: ASTNode;
    map?: RawSourceMap;
}
export declare function createCodeGenerator(options?: CodeGenOptions): CodeGenerator;
export declare function generateMessageFunction(msg: string, options: CodeGenOptions): CodeGenResult<ResourceNode>;
export declare function mapLinesColumns(resMap: RawSourceMap, codeMaps: Map<string, RawSourceMap>, inSourceMap?: RawSourceMap): RawSourceMap | null;
