var __create = Object.create;
var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __getOwnPropNames = Object.getOwnPropertyNames;
var __getProtoOf = Object.getPrototypeOf;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __export = (target, all) => {
  for (var name2 in all)
    __defProp(target, name2, { get: all[name2], enumerable: true });
};
var __copyProps = (to, from, except, desc) => {
  if (from && typeof from === "object" || typeof from === "function") {
    for (let key of __getOwnPropNames(from))
      if (!__hasOwnProp.call(to, key) && key !== except)
        __defProp(to, key, { get: () => from[key], enumerable: !(desc = __getOwnPropDesc(from, key)) || desc.enumerable });
  }
  return to;
};
var __toESM = (mod, isNodeMode, target) => (target = mod != null ? __create(__getProtoOf(mod)) : {}, __copyProps(isNodeMode || !mod || !mod.__esModule ? __defProp(target, "default", { value: mod, enumerable: true }) : target, mod));
var __toCommonJS = (mod) => __copyProps(__defProp({}, "__esModule", { value: true }), mod);
var stdin_exports = {};
__export(stdin_exports, {
  TABS_KEY: () => TABS_KEY,
  default: () => stdin_default
});
module.exports = __toCommonJS(stdin_exports);
var import_vue = require("vue");
var import_vue2 = require("vue");
var import_utils = require("../utils");
var import_utils2 = require("./utils");
var import_use = require("@vant/use");
var import_use_id = require("../composables/use-id");
var import_use_route = require("../composables/use-route");
var import_use_refs = require("../composables/use-refs");
var import_use_expose = require("../composables/use-expose");
var import_on_popup_reopen = require("../composables/on-popup-reopen");
var import_sticky = require("../sticky");
var import_TabsTitle = __toESM(require("./TabsTitle"));
var import_TabsContent = __toESM(require("./TabsContent"));
const [name, bem] = (0, import_utils.createNamespace)("tabs");
const tabsProps = {
  type: (0, import_utils.makeStringProp)("line"),
  color: String,
  border: Boolean,
  sticky: Boolean,
  shrink: Boolean,
  active: (0, import_utils.makeNumericProp)(0),
  duration: (0, import_utils.makeNumericProp)(0.3),
  animated: Boolean,
  ellipsis: import_utils.truthProp,
  swipeable: Boolean,
  scrollspy: Boolean,
  offsetTop: (0, import_utils.makeNumericProp)(0),
  background: String,
  lazyRender: import_utils.truthProp,
  lineWidth: import_utils.numericProp,
  lineHeight: import_utils.numericProp,
  beforeChange: Function,
  swipeThreshold: (0, import_utils.makeNumericProp)(5),
  titleActiveColor: String,
  titleInactiveColor: String
};
const TABS_KEY = Symbol(name);
var stdin_default = (0, import_vue2.defineComponent)({
  name,
  props: tabsProps,
  emits: ["click", "change", "scroll", "disabled", "rendered", "click-tab", "update:active"],
  setup(props, {
    emit,
    slots
  }) {
    var _a, _b;
    if (process.env.NODE_ENV !== "production") {
      const props2 = (_b = (_a = (0, import_vue2.getCurrentInstance)()) == null ? void 0 : _a.vnode) == null ? void 0 : _b.props;
      if (props2 && "onClick" in props2) {
        console.warn('[Vant] Tabs: "click" event is deprecated, using "click-tab" instead.');
      }
      if (props2 && "onDisabled" in props2) {
        console.warn('[Vant] Tabs: "disabled" event is deprecated, using "click-tab" instead.');
      }
    }
    let tabHeight;
    let lockScroll;
    let stickyFixed;
    const root = (0, import_vue2.ref)();
    const navRef = (0, import_vue2.ref)();
    const wrapRef = (0, import_vue2.ref)();
    const id = (0, import_use_id.useId)();
    const scroller = (0, import_use.useScrollParent)(root);
    const [titleRefs, setTitleRefs] = (0, import_use_refs.useRefs)();
    const {
      children,
      linkChildren
    } = (0, import_use.useChildren)(TABS_KEY);
    const state = (0, import_vue2.reactive)({
      inited: false,
      position: "",
      lineStyle: {},
      currentIndex: -1
    });
    const scrollable = (0, import_vue2.computed)(() => children.length > props.swipeThreshold || !props.ellipsis || props.shrink);
    const navStyle = (0, import_vue2.computed)(() => ({
      borderColor: props.color,
      background: props.background
    }));
    const getTabName = (tab, index) => {
      var _a2;
      return (_a2 = tab.name) != null ? _a2 : index;
    };
    const currentName = (0, import_vue2.computed)(() => {
      const activeTab = children[state.currentIndex];
      if (activeTab) {
        return getTabName(activeTab, state.currentIndex);
      }
    });
    const offsetTopPx = (0, import_vue2.computed)(() => (0, import_utils.unitToPx)(props.offsetTop));
    const scrollOffset = (0, import_vue2.computed)(() => {
      if (props.sticky) {
        return offsetTopPx.value + tabHeight;
      }
      return 0;
    });
    const scrollIntoView = (immediate) => {
      const nav = navRef.value;
      const titles = titleRefs.value;
      if (!scrollable.value || !nav || !titles || !titles[state.currentIndex]) {
        return;
      }
      const title = titles[state.currentIndex].$el;
      const to = title.offsetLeft - (nav.offsetWidth - title.offsetWidth) / 2;
      (0, import_utils2.scrollLeftTo)(nav, to, immediate ? 0 : +props.duration);
    };
    const setLine = () => {
      const shouldAnimate = state.inited;
      (0, import_vue2.nextTick)(() => {
        const titles = titleRefs.value;
        if (!titles || !titles[state.currentIndex] || props.type !== "line" || (0, import_utils.isHidden)(root.value)) {
          return;
        }
        const title = titles[state.currentIndex].$el;
        const {
          lineWidth,
          lineHeight
        } = props;
        const left = title.offsetLeft + title.offsetWidth / 2;
        const lineStyle = {
          width: (0, import_utils.addUnit)(lineWidth),
          backgroundColor: props.color,
          transform: `translateX(${left}px) translateX(-50%)`
        };
        if (shouldAnimate) {
          lineStyle.transitionDuration = `${props.duration}s`;
        }
        if ((0, import_utils.isDef)(lineHeight)) {
          const height = (0, import_utils.addUnit)(lineHeight);
          lineStyle.height = height;
          lineStyle.borderRadius = height;
        }
        state.lineStyle = lineStyle;
      });
    };
    const findAvailableTab = (index) => {
      const diff = index < state.currentIndex ? -1 : 1;
      while (index >= 0 && index < children.length) {
        if (!children[index].disabled) {
          return index;
        }
        index += diff;
      }
    };
    const setCurrentIndex = (currentIndex) => {
      const newIndex = findAvailableTab(currentIndex);
      if (!(0, import_utils.isDef)(newIndex)) {
        return;
      }
      const newTab = children[newIndex];
      const newName = getTabName(newTab, newIndex);
      const shouldEmitChange = state.currentIndex !== null;
      state.currentIndex = newIndex;
      if (newName !== props.active) {
        emit("update:active", newName);
        if (shouldEmitChange) {
          emit("change", newName, newTab.title);
        }
      }
    };
    const setCurrentIndexByName = (name2) => {
      const matched = children.find((tab, index2) => getTabName(tab, index2) === name2);
      const index = matched ? children.indexOf(matched) : 0;
      setCurrentIndex(index);
    };
    const scrollToCurrentContent = (immediate = false) => {
      if (props.scrollspy) {
        const target = children[state.currentIndex].$el;
        if (target && scroller.value) {
          const to = (0, import_utils.getElementTop)(target, scroller.value) - scrollOffset.value;
          lockScroll = true;
          (0, import_utils2.scrollTopTo)(scroller.value, to, immediate ? 0 : +props.duration, () => {
            lockScroll = false;
          });
        }
      }
    };
    const onClickTab = (item, index, event) => {
      const {
        title,
        disabled
      } = children[index];
      const name2 = getTabName(children[index], index);
      if (disabled) {
        emit("disabled", name2, title);
      } else {
        (0, import_utils.callInterceptor)(props.beforeChange, {
          args: [name2],
          done: () => {
            setCurrentIndex(index);
            scrollToCurrentContent();
          }
        });
        emit("click", name2, title);
        (0, import_use_route.route)(item);
      }
      emit("click-tab", {
        name: name2,
        title,
        event,
        disabled
      });
    };
    const onStickyScroll = (params) => {
      stickyFixed = params.isFixed;
      emit("scroll", params);
    };
    const scrollTo = (name2) => {
      (0, import_vue2.nextTick)(() => {
        setCurrentIndexByName(name2);
        scrollToCurrentContent(true);
      });
    };
    const getCurrentIndexOnScroll = () => {
      for (let index = 0; index < children.length; index++) {
        const {
          top
        } = (0, import_use.useRect)(children[index].$el);
        if (top > scrollOffset.value) {
          return index === 0 ? 0 : index - 1;
        }
      }
      return children.length - 1;
    };
    const onScroll = () => {
      if (props.scrollspy && !lockScroll) {
        const index = getCurrentIndexOnScroll();
        setCurrentIndex(index);
      }
    };
    const renderNav = () => children.map((item, index) => (0, import_vue.createVNode)(import_TabsTitle.default, (0, import_vue.mergeProps)({
      "key": item.id,
      "id": `${id}-${index}`,
      "ref": setTitleRefs(index),
      "type": props.type,
      "color": props.color,
      "style": item.titleStyle,
      "class": item.titleClass,
      "shrink": props.shrink,
      "isActive": index === state.currentIndex,
      "controls": item.id,
      "scrollable": scrollable.value,
      "activeColor": props.titleActiveColor,
      "inactiveColor": props.titleInactiveColor,
      "onClick": (event) => onClickTab(item, index, event)
    }, (0, import_utils.pick)(item, ["dot", "badge", "title", "disabled", "showZeroBadge"])), {
      title: item.$slots.title
    }));
    const renderLine = () => {
      if (props.type === "line" && children.length) {
        return (0, import_vue.createVNode)("div", {
          "class": bem("line"),
          "style": state.lineStyle
        }, null);
      }
    };
    const renderHeader = () => {
      var _a2, _b2;
      const {
        type,
        border
      } = props;
      return (0, import_vue.createVNode)("div", {
        "ref": wrapRef,
        "class": [bem("wrap"), {
          [import_utils.BORDER_TOP_BOTTOM]: type === "line" && border
        }]
      }, [(0, import_vue.createVNode)("div", {
        "ref": navRef,
        "role": "tablist",
        "class": bem("nav", [type, {
          shrink: props.shrink,
          complete: scrollable.value
        }]),
        "style": navStyle.value,
        "aria-orientation": "horizontal"
      }, [(_a2 = slots["nav-left"]) == null ? void 0 : _a2.call(slots), renderNav(), renderLine(), (_b2 = slots["nav-right"]) == null ? void 0 : _b2.call(slots)])]);
    };
    (0, import_vue2.watch)([() => props.color, import_utils.windowWidth], setLine);
    (0, import_vue2.watch)(() => props.active, (value) => {
      if (value !== currentName.value) {
        setCurrentIndexByName(value);
      }
    });
    (0, import_vue2.watch)(() => children.length, () => {
      if (state.inited) {
        setCurrentIndexByName(props.active);
        setLine();
        (0, import_vue2.nextTick)(() => {
          scrollIntoView(true);
        });
      }
    });
    (0, import_vue2.watch)(() => state.currentIndex, () => {
      scrollIntoView();
      setLine();
      if (stickyFixed && !props.scrollspy) {
        (0, import_utils.setRootScrollTop)(Math.ceil((0, import_utils.getElementTop)(root.value) - offsetTopPx.value));
      }
    });
    const init = () => {
      setCurrentIndexByName(props.active);
      (0, import_vue2.nextTick)(() => {
        state.inited = true;
        if (wrapRef.value) {
          tabHeight = (0, import_use.useRect)(wrapRef.value).height;
        }
        scrollIntoView(true);
      });
    };
    const onRendered = (name2, title) => emit("rendered", name2, title);
    (0, import_use_expose.useExpose)({
      resize: setLine,
      scrollTo
    });
    (0, import_vue2.onActivated)(setLine);
    (0, import_on_popup_reopen.onPopupReopen)(setLine);
    (0, import_use.onMountedOrActivated)(init);
    (0, import_use.useEventListener)("scroll", onScroll, {
      target: scroller
    });
    linkChildren({
      id,
      props,
      setLine,
      onRendered,
      currentName,
      scrollIntoView
    });
    return () => {
      var _a2;
      return (0, import_vue.createVNode)("div", {
        "ref": root,
        "class": bem([props.type])
      }, [props.sticky ? (0, import_vue.createVNode)(import_sticky.Sticky, {
        "container": root.value,
        "offsetTop": offsetTopPx.value,
        "onScroll": onStickyScroll
      }, {
        default: () => {
          var _a3;
          return [renderHeader(), (_a3 = slots["nav-bottom"]) == null ? void 0 : _a3.call(slots)];
        }
      }) : [renderHeader(), (_a2 = slots["nav-bottom"]) == null ? void 0 : _a2.call(slots)], (0, import_vue.createVNode)(import_TabsContent.default, {
        "count": children.length,
        "inited": state.inited,
        "animated": props.animated,
        "duration": props.duration,
        "swipeable": props.swipeable,
        "lazyRender": props.lazyRender,
        "currentIndex": state.currentIndex,
        "onChange": setCurrentIndex
      }, {
        default: () => {
          var _a3;
          return [(_a3 = slots.default) == null ? void 0 : _a3.call(slots)];
        }
      })]);
    };
  }
});
