import request from "@/common/request";
export default {
  getCanUse(data) {
    return request({
      url: "/api/index/canUse",
      data
    });
  },
    getOrderDetail(data) {
        return request({
            url: "/api/order/detail/" + data,
        });
    },
    afterSaleImg() {
        return request({
            url: "/api/order/afterSaleImg/"
        });
    },
    getOrderList(data) {
        return request({
            url: "/api/order/list",
            method: 'POST',
            data
        });
    },
    settleInfo(data) {
        return request({
            url: "/api/order/settleInfo",
            method: 'POST',
            data
        });
    },
    orderAdd(data) {
        return request({
            url: "/api/order/add",
            method: 'POST',
            data
        });
    },
    orderPay(data) {
        return request({
            url: "/api/order/pay",
            method: 'POST',
            data
        });
    },
    remindDeliverGoods(data) {
        return request({
            url: "/api/order/remindDeliverGoods",
            data,
            noToast: true
        });
    },
    confirmReceipt(data) {
        return request({
            url: `/api/order/confirmReceipt/${data.orderId}?domain=${data.domain}`,
        });
    },
    orderCancel(id) {
        return request({
            url: "/api/order/cancel/" + id,
        });
    },
    platfromlist() {
        return request({
            url: "/api/channel/platfromlist",
        });
    },
    batchAdd(data) {
        return request({
            url: "/api/cart/batchAdd",
            method: 'POST',
            data
        });
    },
};
//# sourceMappingURL=order.js.map